/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.functionassociation;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.actions.PopupActionProvider;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.label.GDLabel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.app.services.FunctionComparisonService;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.feature.vt.api.db.DeletedMatch;
import ghidra.feature.vt.api.impl.VTEvent;
import ghidra.feature.vt.api.impl.VersionTrackingChangeRecord;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.CreateManualMatchAction;
import ghidra.feature.vt.gui.actions.CreateManualMatchAndAcceptAction;
import ghidra.feature.vt.gui.actions.CreateManualMatchAndAcceptAndApplyAction;
import ghidra.feature.vt.gui.actions.SelectExistingMatchAction;
import ghidra.feature.vt.gui.duallisting.VTListingNavigator;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.functionassociation.FilterSettings;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionAssociationCompareContext;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionAssociationContext;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionAssociationListener;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionAssociationTableModel;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionRowObject;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.features.base.codecompare.listing.ListingCodeComparisonView;
import ghidra.features.base.codecompare.panel.CodeComparisonView;
import ghidra.features.base.codecompare.panel.FunctionComparisonPanel;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.EventType;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Duo;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;

public class VTFunctionAssociationProvider
extends ComponentProviderAdapter
implements VTControllerListener,
PopupActionProvider {
    private static final String FILTER_SETTINGS_KEY = "FUNCTION_FILTER_SETTINGS";
    private static final String BASE_TITLE = "Version Tracking Functions";
    private static final Icon PROVIDER_ICON = new GIcon("icon.version.tracking.provider.function");
    private static final String SOURCE_TITLE = "Source";
    private static final String DESTINATION_TITLE = "Destination";
    private static final String NO_SESSION = "None";
    private static final Icon SHOW_LISTINGS_ICON = new GIcon("icon.version.tracking.action.show.listings");
    public static final Icon FILTER_NOT_ACCEPTED_ICON = new GIcon("icon.version.tracking.action.function.filter.not.accepted");
    private static final String SHOW_COMPARE_ACTION_GROUP = "A9_ShowCompare";
    private GhidraTable sourceFunctionsTable;
    private GhidraTable destinationFunctionsTable;
    private VTFunctionAssociationTableModel sourceFunctionsModel;
    private VTFunctionAssociationTableModel destinationFunctionsModel;
    private JComponent mainPanel;
    private GhidraTableFilterPanel<VTFunctionRowObject> sourceTableFilterPanel;
    private GhidraTableFilterPanel<VTFunctionRowObject> destinationTableFilterPanel;
    private GhidraThreadedTablePanel<VTFunctionRowObject> sourceThreadedTablePanel;
    private GhidraThreadedTablePanel<VTFunctionRowObject> destinationThreadedTablePanel;
    private final VTController controller;
    private Set<VTFunctionAssociationListener> functionAssociationListeners = new HashSet<VTFunctionAssociationListener>();
    private JSplitPane splitPane;
    private JLabel statusLabel;
    private String NO_ERROR_MESSAGE;
    private String matchStatus = this.NO_ERROR_MESSAGE = " ";
    private JLabel sourceSessionLabel;
    private JLabel destinationSessionLabel;
    private FilterSettings filterSettings = FilterSettings.SHOW_ALL;
    private JPanel dualTablePanel;
    private FunctionComparisonPanel functionComparisonPanel;
    private JSplitPane comparisonSplitPane;
    private ToggleDualListingVisibilityAction toggleListingVisibility;

    public VTFunctionAssociationProvider(VTController controller) {
        super(controller.getTool(), BASE_TITLE, VTPlugin.OWNER);
        this.controller = controller;
        this.mainPanel = this.createWorkPanel();
        this.setWindowGroup("VTResults");
        this.setIcon(PROVIDER_ICON);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setIntraGroupPosition(WindowPosition.STACK);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Functions_Table"));
        this.addToTool();
        this.createActions();
        this.addGeneralCodeComparisonActions();
        controller.addListener(this);
        this.tool.addPopupActionProvider((PopupActionProvider)this);
    }

    private void createActions() {
        CreateManualMatchAction manualMatchAction = new CreateManualMatchAction(this.controller);
        this.addLocalAction((DockingActionIf)manualMatchAction);
        this.addLocalAction((DockingActionIf)new CreateManualMatchAndAcceptAction(this.controller));
        this.addLocalAction((DockingActionIf)new CreateManualMatchAndAcceptAndApplyAction(this.controller));
        SelectExistingMatchAction selectAction = new SelectExistingMatchAction(this.controller);
        this.addLocalAction((DockingActionIf)selectAction);
        this.createFilterAction();
    }

    private void createFilterAction() {
        MultiStateDockingAction<FilterSettings> filterAction = new MultiStateDockingAction<FilterSettings>("Function Association Functions Filter", VTPlugin.OWNER){

            public void actionStateChanged(ActionState<FilterSettings> newActionState, EventTrigger trigger) {
                VTFunctionAssociationProvider.this.filterSettings = (FilterSettings)((Object)newActionState.getUserData());
                VTFunctionAssociationProvider.this.sourceFunctionsModel.setFilterSettings(VTFunctionAssociationProvider.this.filterSettings);
                VTFunctionAssociationProvider.this.destinationFunctionsModel.setFilterSettings(VTFunctionAssociationProvider.this.filterSettings);
            }
        };
        filterAction.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Functions_Filter"));
        GIcon allFunctionsIcon = new GIcon("icon.version.tracking.function.filter.all");
        ActionState allFunctionsActionState = new ActionState("Show All Functions", (Icon)allFunctionsIcon, (Object)FilterSettings.SHOW_ALL);
        allFunctionsActionState.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Show_All_Functions"));
        GIcon unmatchedIcon = new GIcon("icon.version.tracking.function.filter.unmatched");
        ActionState unmatchedOnlyActionState = new ActionState("Show Only Unmatched Functions", (Icon)unmatchedIcon, (Object)FilterSettings.SHOW_UNMATCHED);
        unmatchedOnlyActionState.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Show_Unmatched_Functions"));
        ActionState unacceptedOnlyActionState = new ActionState("Show Only Unaccepted Match Functions", FILTER_NOT_ACCEPTED_ICON, (Object)FilterSettings.SHOW_UNACCEPTED);
        unacceptedOnlyActionState.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Show_Unaccepted_Functions"));
        filterAction.addActionState(allFunctionsActionState);
        filterAction.addActionState(unmatchedOnlyActionState);
        filterAction.addActionState(unacceptedOnlyActionState);
        this.addLocalAction((DockingActionIf)filterAction);
    }

    private void doReloadFunctions() {
        this.sourceFunctionsModel.reload();
        this.destinationFunctionsModel.reload();
    }

    public void componentHidden() {
        this.sourceFunctionsModel.clear();
        this.destinationFunctionsModel.clear();
    }

    public void componentShown() {
        this.reloadFromSession();
    }

    public Function getSelectedSourceFunction() {
        int selectedRowCount = this.sourceFunctionsTable.getSelectedRowCount();
        if (selectedRowCount == 1) {
            int selectedRow = this.sourceFunctionsTable.getSelectedRow();
            return this.sourceFunctionsModel.getFunction(selectedRow);
        }
        return null;
    }

    public Function getSelectedDestinationFunction() {
        int selectedRowCount = this.destinationFunctionsTable.getSelectedRowCount();
        if (selectedRowCount == 1) {
            int selectedRow = this.destinationFunctionsTable.getSelectedRow();
            return this.destinationFunctionsModel.getFunction(selectedRow);
        }
        return null;
    }

    public List<DockingActionIf> getPopupActions(Tool t, ActionContext context) {
        ListingCodeComparisonView dualListingProvider;
        if (context.getComponentProvider() == this && (dualListingProvider = this.functionComparisonPanel.getDualListingView()) != null) {
            ListingPanel leftPanel = dualListingProvider.getListingPanel(Duo.Side.LEFT);
            return leftPanel.getHeaderActions(this.getOwner());
        }
        return new ArrayList<DockingActionIf>();
    }

    public ActionContext getActionContext(MouseEvent event) {
        boolean isToolbarButtonAction;
        Object source = event != null ? event.getSource() : null;
        Component sourceComponent = source instanceof Component ? (Component)source : null;
        Function sourceFunction = this.getSelectedSourceFunction();
        Function destinationFunction = this.getSelectedDestinationFunction();
        if (this.dualTablePanel.isAncestorOf(sourceComponent)) {
            return new VTFunctionAssociationContext(this.tool, sourceFunction, destinationFunction, this.getExistingMatch(sourceFunction, destinationFunction));
        }
        boolean bl = isToolbarButtonAction = event == null;
        if (isToolbarButtonAction || this.functionComparisonPanel.isAncestorOf(sourceComponent)) {
            ListingCodeComparisonView dualListingProvider = this.functionComparisonPanel.getDualListingView();
            boolean isShowingDualListing = dualListingProvider != null && dualListingProvider.isVisible();
            boolean sourceIsADualFieldPanel = isShowingDualListing && dualListingProvider.isAncestorOf(sourceComponent) && sourceComponent instanceof FieldPanel;
            ListingPanel listingPanel = null;
            if (sourceIsADualFieldPanel) {
                listingPanel = dualListingProvider.getListingPanel((FieldPanel)sourceComponent);
            } else if (isToolbarButtonAction && isShowingDualListing) {
                listingPanel = dualListingProvider.getActiveListingPanel();
            }
            if (listingPanel != null) {
                VTListingNavigator vtListingNavigator = new VTListingNavigator(listingPanel);
                VTFunctionAssociationCompareContext vtListingContext = new VTFunctionAssociationCompareContext((ComponentProvider)this, vtListingNavigator, this.tool, sourceFunction, destinationFunction, this.getExistingMatch(sourceFunction, destinationFunction));
                vtListingContext.setCodeComparisonPanel((CodeComparisonView)dualListingProvider);
                vtListingContext.setContextObject(dualListingProvider);
                vtListingContext.setSourceObject(source);
                return vtListingContext;
            }
            ActionContext actionContext = this.functionComparisonPanel.getActionContext(event, (ComponentProvider)this);
            if (actionContext != null) {
                return actionContext;
            }
            return new VTFunctionAssociationContext(this.tool, sourceFunction, destinationFunction, this.getExistingMatch(sourceFunction, destinationFunction));
        }
        return null;
    }

    private VTMatch getExistingMatch(Function sourceFunction, Function destinationFunction) {
        if (sourceFunction == null || destinationFunction == null) {
            return null;
        }
        Address sourceAddress = sourceFunction.getEntryPoint();
        Address destinationAddress = destinationFunction.getEntryPoint();
        VTSession session = this.controller.getSession();
        List<VTMatchSet> matchSets = session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            Collection<VTMatch> matches = matchSet.getMatches(sourceAddress, destinationAddress);
            Iterator<VTMatch> iterator = matches.iterator();
            if (!iterator.hasNext()) continue;
            VTMatch match = iterator.next();
            return match;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    void showFunctions() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
        this.splitPane.setDividerLocation(0.5);
    }

    @Override
    public void disposed() {
        this.sourceThreadedTablePanel.dispose();
        this.destinationThreadedTablePanel.dispose();
        this.functionComparisonPanel.dispose();
        this.sourceFunctionsTable.dispose();
        this.sourceTableFilterPanel.dispose();
        this.destinationFunctionsTable.dispose();
        this.destinationTableFilterPanel.dispose();
        this.functionComparisonPanel.dispose();
        this.tool.removePopupActionProvider((PopupActionProvider)this);
    }

    public void reload() {
        if (this.isVisible()) {
            this.doReloadFunctions();
            this.notifyContextChanged();
        }
    }

    private JComponent createWorkPanel() {
        this.dualTablePanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.createSourceFunctionPanel(), this.createDestinationFunctionPanel());
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerSize(6);
        this.splitPane.setDividerLocation(0.5);
        this.dualTablePanel.add((Component)this.splitPane, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusLabel = new GDLabel(this.NO_ERROR_MESSAGE);
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setForeground((Color)GThemeDefaults.Colors.ERROR);
        this.statusLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VTFunctionAssociationProvider.this.updateMatchStatusToolTip();
            }
        });
        statusPanel.add((Component)this.statusLabel, "Center");
        this.dualTablePanel.add((Component)statusPanel, "South");
        FunctionComparisonService fcService = (FunctionComparisonService)this.tool.getService(FunctionComparisonService.class);
        this.functionComparisonPanel = fcService.createComparisonViewer();
        this.addSpecificCodeComparisonActions();
        this.functionComparisonPanel.setCurrentTabbedComponent("Listing View");
        this.functionComparisonPanel.setTitlePrefixes("Source:", "Destination:");
        this.comparisonSplitPane = new JSplitPane(0, this.dualTablePanel, (Component)this.functionComparisonPanel);
        this.comparisonSplitPane.setResizeWeight(0.4);
        JPanel functionsPanel = new JPanel(new BorderLayout());
        functionsPanel.add((Component)this.comparisonSplitPane, "Center");
        return functionsPanel;
    }

    private void addSpecificCodeComparisonActions() {
        DockingAction[] actions;
        for (DockingAction dockingAction : actions = this.functionComparisonPanel.getCodeComparisonActions()) {
            this.addLocalAction((DockingActionIf)dockingAction);
        }
    }

    private void addGeneralCodeComparisonActions() {
        this.toggleListingVisibility = new ToggleDualListingVisibilityAction();
        this.addLocalAction((DockingActionIf)this.toggleListingVisibility);
    }

    private void showComparisonPanelWithinProvider(boolean show) {
        boolean contains = this.mainPanel.isAncestorOf(this.comparisonSplitPane);
        if (show) {
            if (!contains) {
                this.mainPanel.remove(this.dualTablePanel);
                this.comparisonSplitPane.add(this.dualTablePanel);
                this.comparisonSplitPane.add((Component)this.functionComparisonPanel);
                this.mainPanel.add((Component)this.comparisonSplitPane, "Center");
                this.mainPanel.validate();
                this.functionComparisonPanel.loadFunctions(this.getSelectedSourceFunction(), this.getSelectedDestinationFunction());
                this.dualTablePanel.requestFocus();
            }
        } else if (contains) {
            this.mainPanel.remove(this.comparisonSplitPane);
            this.comparisonSplitPane.remove((Component)this.functionComparisonPanel);
            this.comparisonSplitPane.remove(this.dualTablePanel);
            this.mainPanel.add((Component)this.dualTablePanel, "Center");
            this.mainPanel.validate();
            this.dualTablePanel.requestFocus();
        }
        this.toggleListingVisibility.setSelected(show);
        this.functionComparisonPanel.updateActionEnablement();
    }

    private JComponent createSourceFunctionPanel() {
        Program sourceProgram = this.controller.getSourceProgram();
        this.sourceFunctionsModel = new VTFunctionAssociationTableModel(this.tool, this.controller, sourceProgram, true);
        this.sourceThreadedTablePanel = new GhidraThreadedTablePanel((ThreadedTableModel)this.sourceFunctionsModel, 1000);
        this.sourceFunctionsTable = this.sourceThreadedTablePanel.getTable();
        this.sourceFunctionsTable.setPreferenceKey("VTFunctionAssociationTableModel - Source Function Table");
        this.sourceFunctionsTable.installNavigation((ServiceProvider)this.tool);
        this.sourceFunctionsTable.setAutoLookupColumn(0);
        this.sourceFunctionsTable.setAutoResizeMode(2);
        this.sourceFunctionsTable.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.sourceFunctionsTable.setRowSelectionAllowed(true);
        this.sourceFunctionsTable.setSelectionMode(0);
        this.sourceFunctionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.goToSelectedSourceFunction();
            this.validateSelectedMatch();
            this.notifyContextChanged();
            this.functionComparisonPanel.loadFunctions(this.getSelectedSourceFunction(), this.getSelectedDestinationFunction());
        });
        this.sourceFunctionsModel.addTableModelListener(new TitleUpdateListener());
        this.sourceFunctionsTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.sourceTableFilterPanel = new GhidraTableFilterPanel((JTable)this.sourceFunctionsTable, (RowObjectTableModel)this.sourceFunctionsModel);
        JPanel sourceFunctionPanel = new JPanel(new BorderLayout());
        String sourceString = sourceProgram != null ? sourceProgram.getDomainFile().toString() : NO_SESSION;
        String sourceTitle = "Source = " + sourceString;
        this.sourceSessionLabel = new GDLabel(sourceTitle);
        this.sourceSessionLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        sourceFunctionPanel.add((Component)this.sourceSessionLabel, "North");
        sourceFunctionPanel.add((Component)this.sourceThreadedTablePanel, "Center");
        sourceFunctionPanel.add((Component)this.sourceTableFilterPanel, "South");
        String namePrefix = "Source Functions";
        this.sourceFunctionsTable.setAccessibleNamePrefix(namePrefix);
        this.sourceTableFilterPanel.setAccessibleNamePrefix(namePrefix);
        return sourceFunctionPanel;
    }

    private JComponent createDestinationFunctionPanel() {
        Program destinationProgram = this.controller.getDestinationProgram();
        this.destinationFunctionsModel = new VTFunctionAssociationTableModel(this.tool, this.controller, destinationProgram, false);
        this.destinationThreadedTablePanel = new GhidraThreadedTablePanel((ThreadedTableModel)this.destinationFunctionsModel, 1000);
        this.destinationFunctionsTable = this.destinationThreadedTablePanel.getTable();
        this.destinationFunctionsTable.setPreferenceKey("VTFunctionAssociationTableModel - Destination Function Table");
        this.destinationFunctionsTable.installNavigation((ServiceProvider)this.tool);
        this.destinationFunctionsTable.setAutoLookupColumn(0);
        this.destinationFunctionsTable.setAutoResizeMode(2);
        this.destinationFunctionsTable.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.destinationFunctionsTable.setRowSelectionAllowed(true);
        this.destinationFunctionsTable.setSelectionMode(0);
        this.destinationFunctionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.goToSelectedDestinationFunction();
            this.validateSelectedMatch();
            this.notifyContextChanged();
            this.functionComparisonPanel.loadFunctions(this.getSelectedSourceFunction(), this.getSelectedDestinationFunction());
        });
        this.destinationFunctionsModel.addTableModelListener(new TitleUpdateListener());
        JTableHeader functionHeader = this.destinationFunctionsTable.getTableHeader();
        functionHeader.setUpdateTableInRealTime(true);
        this.destinationFunctionsTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.destinationTableFilterPanel = new GhidraTableFilterPanel((JTable)this.destinationFunctionsTable, (RowObjectTableModel)this.destinationFunctionsModel);
        JPanel destinationFunctionPanel = new JPanel(new BorderLayout());
        String destinationString = destinationProgram != null ? destinationProgram.getDomainFile().toString() : NO_SESSION;
        String destinationTitle = "Destination = " + destinationString;
        this.destinationSessionLabel = new GDLabel(destinationTitle);
        this.destinationSessionLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        destinationFunctionPanel.add((Component)this.destinationSessionLabel, "North");
        destinationFunctionPanel.add((Component)this.destinationThreadedTablePanel, "Center");
        destinationFunctionPanel.add((Component)this.destinationTableFilterPanel, "South");
        String namePrefix = "Destination Functions";
        this.destinationFunctionsTable.setAccessibleNamePrefix(namePrefix);
        this.destinationTableFilterPanel.setAccessibleNamePrefix(namePrefix);
        return destinationFunctionPanel;
    }

    protected void goToSelectedSourceFunction() {
        Function sourceFunction = this.getSelectedSourceFunction();
        if (sourceFunction != null) {
            this.controller.gotoSourceLocation(new ProgramLocation(sourceFunction.getProgram(), sourceFunction.getEntryPoint()));
        }
    }

    protected void goToSelectedDestinationFunction() {
        Function destinationFunction = this.getSelectedDestinationFunction();
        if (destinationFunction != null) {
            this.controller.gotoDestinationLocation(new ProgramLocation(destinationFunction.getProgram(), destinationFunction.getEntryPoint()));
        }
    }

    public void addSelectionListener(VTFunctionAssociationListener listener) {
        this.functionAssociationListeners.add(listener);
    }

    private void validateSelectedMatch() {
        int selectedSourceCount = this.sourceFunctionsTable.getSelectedRowCount();
        int selectedDestinationCount = this.destinationFunctionsTable.getSelectedRowCount();
        if (selectedSourceCount == 0 || selectedDestinationCount == 0) {
            String message = "Select a single source function and a single destination function.";
            this.setMatchStatus(message);
            return;
        }
        if (selectedSourceCount > 1 || selectedDestinationCount > 1) {
            String message = "Select no more than a single source function and a single destination function.";
            this.setMatchStatus(message);
            return;
        }
        Function sourceFunction = this.getSelectedSourceFunction();
        Function destinationFunction = this.getSelectedDestinationFunction();
        if (sourceFunction == null || destinationFunction == null) {
            String message = "Select a single source function and a single destination function.";
            this.setMatchStatus(message);
            return;
        }
        VTMatch match = this.getExistingMatch(sourceFunction, destinationFunction);
        if (match != null) {
            String message = "A match already exists between " + sourceFunction.getName() + " and " + destinationFunction.getName() + ".";
            this.setMatchStatus(message);
            return;
        }
        this.setMatchStatus(this.NO_ERROR_MESSAGE);
    }

    private void setMatchStatus(String statusMessage) {
        if (SystemUtilities.isEqual((Object)this.matchStatus, (Object)statusMessage)) {
            return;
        }
        this.matchStatus = statusMessage;
        this.statusLabel.setText(this.matchStatus);
        this.updateMatchStatusToolTip();
    }

    private void updateMatchStatusToolTip() {
        String text = this.statusLabel.getText();
        FontMetrics fm = this.statusLabel.getFontMetrics(this.statusLabel.getFont());
        int messageWidth = 0;
        if (fm != null && text != null) {
            messageWidth = fm.stringWidth(text);
        }
        if (messageWidth > this.statusLabel.getWidth()) {
            this.statusLabel.setToolTipText(text);
        } else {
            this.statusLabel.setToolTipText(null);
        }
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
    }

    @Override
    public void optionsChanged(Options options) {
    }

    @Override
    public void sessionChanged(VTSession session) {
        if (!this.isVisible()) {
            return;
        }
        this.reloadFromSession();
    }

    private void reloadFromSession() {
        Program destinationProgram = this.controller.getDestinationProgram();
        this.destinationFunctionsModel.setProgram(destinationProgram);
        String destinationString = destinationProgram != null ? destinationProgram.getDomainFile().toString() : NO_SESSION;
        String destinationTitle = "Destination = " + destinationString;
        this.destinationSessionLabel.setText(destinationTitle);
        Program sourceProgram = this.controller.getSourceProgram();
        this.sourceFunctionsModel.setProgram(sourceProgram);
        String sourceString = sourceProgram != null ? sourceProgram.getDomainFile().toString() : NO_SESSION;
        String sourceTitle = "Source = " + sourceString;
        this.sourceSessionLabel.setText(sourceTitle);
        this.reload();
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
        if (!this.isVisible()) {
            return;
        }
        if (ev.contains((EventType)DomainObjectEvent.RESTORED)) {
            this.reload();
            return;
        }
        boolean contextChanged = false;
        for (int i = 0; i < ev.numRecords(); ++i) {
            VersionTrackingChangeRecord vtRecord;
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            EventType eventType = doRecord.getEventType();
            if (eventType == VTEvent.MATCH_ADDED) {
                vtRecord = (VersionTrackingChangeRecord)doRecord;
                VTMatch match = (VTMatch)vtRecord.getNewValue();
                this.sourceFunctionsModel.matchAdded(match);
                this.destinationFunctionsModel.matchAdded(match);
                contextChanged = true;
                continue;
            }
            if (eventType == VTEvent.MATCH_DELETED) {
                vtRecord = (VersionTrackingChangeRecord)doRecord;
                DeletedMatch deletedMatch = (DeletedMatch)vtRecord.getOldValue();
                this.sourceFunctionsModel.matchRemoved(deletedMatch);
                this.destinationFunctionsModel.matchRemoved(deletedMatch);
                contextChanged = true;
                continue;
            }
            if (eventType == VTEvent.ASSOCIATION_STATUS_CHANGED) {
                vtRecord = (VersionTrackingChangeRecord)doRecord;
                VTAssociation association = (VTAssociation)vtRecord.getObject();
                this.sourceFunctionsModel.associationChanged(association);
                this.destinationFunctionsModel.associationChanged(association);
                contextChanged = true;
                continue;
            }
            if (eventType == ProgramEvent.FUNCTION_ADDED) {
                this.functionAdded((ProgramChangeRecord)doRecord);
                contextChanged = true;
                continue;
            }
            if (eventType != ProgramEvent.FUNCTION_REMOVED) continue;
            this.functionRemoved((ProgramChangeRecord)doRecord);
            contextChanged = true;
        }
        if (contextChanged) {
            this.notifyContextChanged();
        }
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    private void functionAdded(ProgramChangeRecord record) {
        Function function = (Function)record.getObject();
        Program program = function.getProgram();
        if (program == this.controller.getSourceProgram()) {
            this.sourceFunctionsModel.functionAdded(function);
        } else {
            this.destinationFunctionsModel.functionAdded(function);
        }
    }

    private void functionRemoved(ProgramChangeRecord record) {
        Function function = (Function)record.getObject();
        Program program = function.getProgram();
        if (program == this.controller.getSourceProgram()) {
            this.sourceFunctionsModel.functionRemoved(function);
        } else {
            this.destinationFunctionsModel.functionRemoved(function);
        }
    }

    public void readConfigState(SaveState saveState) {
        this.filterSettings = (FilterSettings)saveState.getEnum(FILTER_SETTINGS_KEY, (Enum)FilterSettings.SHOW_ALL);
        this.sourceFunctionsModel.setFilterSettings(this.filterSettings);
        this.destinationFunctionsModel.setFilterSettings(this.filterSettings);
        this.reload();
    }

    public void writeConfigState(SaveState saveState) {
        saveState.putEnum(FILTER_SETTINGS_KEY, (Enum)this.filterSettings);
    }

    private class ToggleDualListingVisibilityAction
    extends ToggleDockingAction {
        ToggleDualListingVisibilityAction() {
            super("Toggle Dual Listing Visibility", VTFunctionAssociationProvider.this.getName());
            this.setDescription("Toggle Visibility of Dual Comparison Views");
            this.setSelected(true);
            this.setEnabled(true);
            this.setToolBarData(new ToolBarData(SHOW_LISTINGS_ICON, VTFunctionAssociationProvider.SHOW_COMPARE_ACTION_GROUP));
            HelpLocation helpLocation = new HelpLocation("VersionTrackingPlugin", "Function_Association_Show_Hide_Function_Compare");
            this.setHelpLocation(helpLocation);
        }

        public void actionPerformed(ActionContext context) {
            boolean show = !VTFunctionAssociationProvider.this.functionComparisonPanel.isShowing();
            VTFunctionAssociationProvider.this.showComparisonPanelWithinProvider(show);
        }
    }

    private class TitleUpdateListener
    implements TableModelListener {
        private TitleUpdateListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            StringBuffer buffy = new StringBuffer();
            String sessionName = VTFunctionAssociationProvider.this.controller.getVersionTrackingSessionName();
            buffy.append("[Session: ").append(sessionName).append("] - ");
            this.getTableFilterString("Source Functions", (ThreadedTableModel<?, ?>)VTFunctionAssociationProvider.this.sourceFunctionsModel, buffy);
            buffy.append(" / ");
            this.getTableFilterString("Destination Functions", (ThreadedTableModel<?, ?>)VTFunctionAssociationProvider.this.destinationFunctionsModel, buffy);
            VTFunctionAssociationProvider.this.setSubTitle(buffy.toString());
        }

        private void getTableFilterString(String tableName, ThreadedTableModel<?, ?> model, StringBuffer buffy) {
            int filteredCount = model.getRowCount();
            int unfilteredCount = model.getUnfilteredRowCount();
            buffy.append(tableName).append(" - ").append(filteredCount).append(" functions");
            if (filteredCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(')');
            }
        }
    }
}

