/*
 * Decompiled with CFR 0.152.
 */
package help;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;

public class HelpRightArrowIcon
implements Icon {
    private static final int ICON_SIZE = 20;
    private Color color;
    private Shape shape;

    public HelpRightArrowIcon(Color color) {
        this.color = color;
        this.shape = this.buildShape();
    }

    private Shape buildShape() {
        GeneralPath barPath = new GeneralPath();
        double height = 10.0;
        double width = 12.0;
        double thickness = 2.0;
        double arrowthickness = 3.0;
        double top = 20.0 - height;
        double cy = top + height / 2.0;
        double p1x = (20.0 - width) / 2.0;
        double p1y = cy - thickness / 2.0;
        barPath.moveTo(p1x, p1y);
        double barlength = width - 2.0;
        double p2x = p1x + barlength;
        double p2y = p1y;
        barPath.lineTo(p2x, p2y);
        double p3x = p2x;
        double p3y = p2y + thickness;
        barPath.lineTo(p3x, p3y);
        double p4x = p1x;
        double p4y = p3y;
        barPath.lineTo(p4x, p4y);
        barPath.lineTo(p1x, p1y);
        barPath.closePath();
        GeneralPath arrowPath = new GeneralPath();
        p1x = p1x + barlength + arrowthickness;
        p1y = cy;
        arrowPath.moveTo(p1x, p1y);
        double trianglewidth = 5.0;
        p2x = p1x - trianglewidth;
        p2y = top + 1.0;
        arrowPath.lineTo(p2x, p2y);
        p3x = p2x - arrowthickness;
        p3y = p2y;
        arrowPath.lineTo(p3x, p3y);
        p4x = p1x - arrowthickness;
        p4y = cy;
        arrowPath.lineTo(p4x, p4y);
        double p5x = p3x;
        double p5y = 19.0;
        arrowPath.lineTo(p5x, p5y);
        double p6x = p2x;
        double p6y = p5y;
        arrowPath.lineTo(p6x, p6y);
        double p7x = p1x;
        double p7y = p1y;
        arrowPath.lineTo(p7x, p7y);
        arrowPath.closePath();
        AffineTransform identity = new AffineTransform();
        Shape barShape = barPath.createTransformedShape(identity);
        Area barArea = new Area(barShape);
        Shape arrowShape = arrowPath.createTransformedShape(identity);
        Area arrowArea = new Area(arrowShape);
        Area fullArea = new Area();
        fullArea.add(barArea);
        fullArea.add(arrowArea);
        return fullArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            g2d.translate(x, y);
            g2d.setColor(this.color);
            g2d.fill(this.shape);
        }
        finally {
            g2d.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth() {
        return 20;
    }

    @Override
    public int getIconHeight() {
        return 20;
    }
}

