/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex;

import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.DexExceptionHandler;
import com.googlecode.d2j.dex.ExDex2Asm;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.visitors.DexFileVisitor;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.dex.DexToJarExceptionHandler;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

@FileSystemInfo(type="dex2jar", description="Android DEX to JAR", factory=GFileSystemBaseFactory.class)
public class DexToJarFileSystem
extends GFileSystemBase {
    private GFileImpl jarFile;

    public DexToJarFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public GFile getJarFile() {
        return this.jarFile;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        return file.equals((Object)this.jarFile) ? this.getJarFile(this.jarFile.getFSRL(), monitor) : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals((Object)this.root) ? Arrays.asList(this.jarFile) : Collections.emptyList();
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return DexConstants.isDexFile(this.provider);
    }

    private ByteProvider getJarFile(FSRL jarFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, 1L);
        upwtm.setMessage("Converting DEX to JAR...");
        FSRLRoot targetFSRL = this.getFSRL();
        FSRL containerFSRL = targetFSRL.getContainer();
        ByteProvider jarBP = this.fsService.getDerivedByteProviderPush(containerFSRL, jarFSRL, "dex2jar", -1L, arg_0 -> this.lambda$getJarFile$1((TaskMonitor)upwtm, arg_0), monitor);
        return jarBP;
    }

    public void open(TaskMonitor monitor) throws CancelledException, IOException {
        ByteProvider jarBP = this.getJarFile(null, monitor);
        FSRLRoot targetFSRL = this.getFSRL();
        FSRL containerFSRL = targetFSRL.getContainer();
        String baseName = FilenameUtils.removeExtension((String)containerFSRL.getName());
        String jarName = baseName + ".jar";
        FSRL jarFSRL = targetFSRL.withPathMD5(jarName, jarBP.getFSRL().getMD5());
        this.jarFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)(baseName + ".jar"), (boolean)false, (long)jarBP.length(), (FSRL)jarFSRL);
    }

    public void close() throws IOException {
        super.close();
    }

    private /* synthetic */ void lambda$getJarFile$1(final TaskMonitor upwtm, OutputStream os) throws IOException, CancelledException {
        try (final ZipOutputStream outputStream = new ZipOutputStream(os);){
            final DexToJarExceptionHandler exceptionHandler = new DexToJarExceptionHandler();
            byte[] containerFileBytes = this.provider.readBytes(0L, this.provider.length());
            DexFileReader reader = new DexFileReader(containerFileBytes);
            DexFileNode fileNode = new DexFileNode();
            try {
                reader.accept((DexFileVisitor)fileNode, 32);
            }
            catch (Exception ex) {
                exceptionHandler.handleFileException(ex);
            }
            DexFileVisitor visitor = new DexFileVisitor();
            reader.accept(visitor);
            ClassVisitorFactory classVisitorFactory = name -> new ClassVisitor(this, 262144, (ClassVisitor)new ClassWriter(1)){

                public void visitEnd() {
                    byte[] data;
                    super.visitEnd();
                    ClassWriter cw = (ClassWriter)this.cv;
                    try {
                        data = cw.toByteArray();
                    }
                    catch (Exception ex) {
                        Msg.warn((Object)((Object)this), (Object)String.format("ASM fail to generate .class file: %s", name));
                        exceptionHandler.handleFileException(ex);
                        return;
                    }
                    try {
                        ZipEntry entry = new ZipEntry(name + ".class");
                        outputStream.putNextEntry(entry);
                        outputStream.write(data);
                        outputStream.closeEntry();
                        upwtm.incrementProgress(1L);
                    }
                    catch (IOException e) {
                        Msg.warn((Object)((Object)this), (Object)e);
                    }
                }
            };
            ExDex2Asm exDex2Asm = new ExDex2Asm((DexExceptionHandler)exceptionHandler);
            exDex2Asm.convertDex(fileNode, classVisitorFactory);
            if (exceptionHandler.getFileException() != null) {
                throw new IOException(exceptionHandler.getFileException());
            }
            outputStream.finish();
        }
    }
}

