/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.generic;

import generic.jar.ResourceFile;
import ghidra.file.crypto.CryptoKeyFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class IpswCryptoKeyFileTemplateWriter {
    private ZipFile ipswZipFile;

    public IpswCryptoKeyFileTemplateWriter(ZipFile ipswZipFile) {
        this.ipswZipFile = ipswZipFile;
    }

    public boolean exists() {
        File ipswFile = new File(this.ipswZipFile.getName());
        ResourceFile xmlFile = new ResourceFile(CryptoKeyFactory.getCryptoDirectory(), ipswFile.getName() + ".xml");
        return xmlFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (!this.ipswZipFile.getName().endsWith(".ipsw")) {
            throw new IOException("File is not an IPSW.");
        }
        File ipswFile = new File(this.ipswZipFile.getName());
        File xmlFile = new File(CryptoKeyFactory.getCryptoDirectory().getFile(true), ipswFile.getName() + ".xml");
        writer.println("<FIRMWARE NAME=\"" + this.ipswZipFile.getName() + "\">");
        try (PrintWriter writer = new PrintWriter(xmlFile);){
            Enumeration<? extends ZipEntry> entries = this.ipswZipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                writer.println("    <FILE PATH=\"/" + entry.getName() + "\">");
                writer.println("        <KEY></KEY>");
                writer.println("        <IV></IV>");
                writer.println("    </FILE>");
            }
            writer.println("</FIRMWARE>");
        }
    }
}

