/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;

public class SquashDirectoryTableEntry {
    private final int addressOffset;
    private final short inodeNumberOffset;
    private final int inodeType;
    private final int nameSize;
    private final int inodeNumber;
    private final String path;

    public SquashDirectoryTableEntry(BinaryReader reader, SquashSuperBlock superBlock, long baseInode) throws IOException {
        this.addressOffset = reader.readNextUnsignedShort();
        this.inodeNumberOffset = reader.readNextShort();
        this.inodeType = reader.readNextUnsignedShort();
        this.nameSize = reader.readNextUnsignedShort();
        this.path = reader.readNextUtf8String(this.nameSize + 1);
        this.inodeNumber = (int)(baseInode + (long)this.inodeNumberOffset);
    }

    public int getAddressOffset() {
        return this.addressOffset;
    }

    public int getInodeType() {
        return this.inodeType;
    }

    public String getFileName() {
        int slashIndex = this.path.lastIndexOf(47);
        if (slashIndex == -1) {
            return this.path;
        }
        return this.path.substring(slashIndex);
    }

    public int getInodeNumber() {
        return this.inodeNumber;
    }

    public String getPath() {
        return this.path;
    }
}

