/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.pdb.classtype.VirtualBaseTableEntry;
import ghidra.program.model.gclass.ClassID;

public class PlaceholderVirtualBaseTableEntry
extends VirtualBaseTableEntry {
    private Long offset;

    public PlaceholderVirtualBaseTableEntry(Long offset) {
        this(offset, null);
    }

    public PlaceholderVirtualBaseTableEntry(ClassID baseId) {
        this(null, baseId);
    }

    public PlaceholderVirtualBaseTableEntry(Long offset, ClassID baseId) {
        super(baseId);
        this.offset = offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Long getOffset() {
        return this.offset;
    }

    void emit(StringBuilder builder, long vbtPtrOffset) {
        PlaceholderVirtualBaseTableEntry.emitLine(builder, this.getOffset(), vbtPtrOffset, this.getClassId().toString());
    }

    static void emitHeader(StringBuilder builder, long ownerOffset, long vbtPtrOffset) {
        builder.append(String.format("%-10s %-10s %-10s\n", "OffInOwner", "OffFromPtr", "Base"));
        PlaceholderVirtualBaseTableEntry.emitLine(builder, ownerOffset, vbtPtrOffset, "'ForClass'");
    }

    static void emitLine(StringBuilder builder, long classOffset, long vbtPtrOffset, String owner) {
        builder.append(String.format("%-10d %-10d %-10s\n", classOffset, classOffset - vbtPtrOffset, owner));
    }
}

