/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.Architecture;
import ghidra.framework.OperatingSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public enum Platform {
    WIN_X86_32(OperatingSystem.WINDOWS, Architecture.X86, "win_x86_32", ".dll", ".exe"),
    WIN_X86_64(OperatingSystem.WINDOWS, Architecture.X86_64, "win_x86_64", ".dll", ".exe"),
    WIN_ARM_64(OperatingSystem.WINDOWS, Architecture.ARM_64, "win_arm_64", ".dll", ".exe"),
    LINUX_X86_32(OperatingSystem.LINUX, Architecture.X86, "linux_x86_32", ".so", ""),
    LINUX_X86_64(OperatingSystem.LINUX, Architecture.X86_64, "linux_x86_64", ".so", ""),
    LINUX_ARM_64(OperatingSystem.LINUX, Architecture.ARM_64, "linux_arm_64", ".so", ""),
    MAC_X86_32(OperatingSystem.MAC_OS_X, Architecture.X86, "mac_x86_32", ".dylib", ""),
    MAC_X86_64(OperatingSystem.MAC_OS_X, Architecture.X86_64, "mac_x86_64", ".dylib", ""),
    MAC_ARM_64(OperatingSystem.MAC_OS_X, Architecture.ARM_64, "mac_arm_64", ".dylib", ""),
    FREEBSD_X86_64(OperatingSystem.FREE_BSD, Architecture.X86_64, "freebsd_x86_64", ".so", ""),
    FREEBSD_ARM_64(OperatingSystem.FREE_BSD, Architecture.ARM_64, "freebsd_arm_64", ".so", ""),
    UNSUPPORTED(OperatingSystem.UNSUPPORTED, Architecture.UNKNOWN, null, null, ""),
    WIN_64(OperatingSystem.WINDOWS, Architecture.X86_64, "win_x86_64", ".dll", ".exe"),
    WIN_UNKOWN(OperatingSystem.WINDOWS, Architecture.UNKNOWN, "win_x86_64", ".dll", ".exe"),
    LINUX(OperatingSystem.LINUX, Architecture.X86, "linux_x86_32", ".so", ""),
    LINUX_64(OperatingSystem.LINUX, Architecture.X86_64, "linux_x86_64", ".so", ""),
    LINUX_UKNOWN(OperatingSystem.LINUX, Architecture.UNKNOWN, "linux_x86_64", ".so", ""),
    MAC_OSX_32(OperatingSystem.MAC_OS_X, Architecture.X86, "mac_x86_32", ".dylib", ""),
    MAC_OSX_64(OperatingSystem.MAC_OS_X, Architecture.X86_64, "mac_x86_64", ".dylib", ""),
    MAC_UNKNOWN(OperatingSystem.MAC_OS_X, Architecture.UNKNOWN, "mac_x86_64", ".dylib", "");

    public static final Platform CURRENT_PLATFORM;
    private OperatingSystem operatingSystem;
    private Architecture architecture;
    private String directoryName;
    private String libraryExtension;
    private final String executableExtension;

    private Platform(OperatingSystem operatingSystem, Architecture architecture, String directoryName, String libraryExtension, String executableExtension) {
        this.operatingSystem = operatingSystem;
        this.architecture = architecture;
        this.directoryName = directoryName;
        this.libraryExtension = libraryExtension;
        this.executableExtension = executableExtension;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getLibraryExtension() {
        return this.libraryExtension;
    }

    public List<String> getAdditionalLibraryPaths() {
        File syswow64;
        String windir;
        ArrayList<String> paths = new ArrayList<String>();
        if (this.operatingSystem == OperatingSystem.LINUX || this.operatingSystem == OperatingSystem.FREE_BSD) {
            paths.add("/bin");
            paths.add("/lib");
            paths.add("/lib64");
            paths.add("/lib/x86_64-linux-gnu");
            paths.add("/lib/aarch64-linux-gnu");
            paths.add("/usr/bin");
            paths.add("/usr/lib");
            paths.add("/usr/X11R6/bin");
            paths.add("/usr/X11R6/lib");
        } else if (this.operatingSystem == OperatingSystem.MAC_OS_X) {
            paths.add("/System/Library/dyld/dyld_shared_cache_arm64e");
            paths.add("/System/Library/dyld/dyld_shared_cache_x86_64");
            paths.add("/System/Library/dyld/dyld_shared_cache_x86_64h");
            paths.add("/System/Cryptexes/OS/System/Library/dyld/dyld_shared_cache_arm64e");
            paths.add("/System/Cryptexes/OS/System/Library/dyld/dyld_shared_cache_x86_64");
            paths.add("/System/Cryptexes/OS/System/Library/dyld/dyld_shared_cache_x86_64h");
        } else if (CURRENT_PLATFORM == WIN_X86_64 && (windir = System.getenv("SystemRoot")) != null && (syswow64 = new File(windir, "SysWOW64")).isDirectory()) {
            paths.add(syswow64.getAbsolutePath());
        }
        return paths;
    }

    public String toString() {
        return this.operatingSystem.toString() + " " + this.architecture.toString();
    }

    private static Platform findCurrentPlatform() {
        for (Platform platform : Platform.values()) {
            if (!Platform.matchesCurrentPlatform(platform)) continue;
            return platform;
        }
        return UNSUPPORTED;
    }

    private static boolean matchesCurrentPlatform(Platform platform) {
        return platform.operatingSystem == OperatingSystem.CURRENT_OPERATING_SYSTEM && platform.architecture == Architecture.CURRENT_ARCHITECTURE;
    }

    public String getExecutableExtension() {
        return this.executableExtension;
    }

    static {
        CURRENT_PLATFORM = Platform.findCurrentPlatform();
    }
}

