/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Prime;
import ghidra.util.datastruct.ShortKeyIndexer;
import java.io.Serializable;

public class ShortObjectHashtable
implements Serializable {
    private ShortKeyIndexer indexer;
    private Object[] values;
    private int capacity;

    public ShortObjectHashtable() {
        this(3);
    }

    public ShortObjectHashtable(short capacity) {
        capacity = (short)Prime.nextPrime(capacity);
        this.capacity = capacity;
        this.indexer = new ShortKeyIndexer(capacity);
        this.values = new Object[capacity];
    }

    public void put(short key, Object value) {
        short index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public Object get(short key) {
        short index = this.indexer.get(key);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public boolean remove(short key) {
        return this.indexer.remove(key) >= 0;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(short key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public short[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        Object[] oldValues = this.values;
        this.values = new Object[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

