/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.filters.AncillaryFilterDialogComponentProvider;
import ghidra.feature.vt.gui.filters.FilterDialogModel;
import ghidra.feature.vt.gui.filters.TagFilter;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.matchtable.AlgorithmFilter;
import ghidra.feature.vt.gui.provider.matchtable.AssociationStatusFilter;
import ghidra.feature.vt.gui.provider.matchtable.MatchAddressRangeFilter;
import ghidra.feature.vt.gui.provider.matchtable.MatchTypeFilter;
import ghidra.feature.vt.gui.provider.matchtable.SymbolTypeFilter;
import ghidra.util.HelpLocation;
import ghidra.util.layout.VariableRowHeightGridLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MatchesFilterDialogComponentProvider
extends AncillaryFilterDialogComponentProvider<VTMatch> {
    protected MatchesFilterDialogComponentProvider(VTController controller, FilterDialogModel<VTMatch> dialogModel) {
        super(controller, "Match Table Filters", dialogModel);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Match_Filters"));
    }

    @Override
    protected JComponent buildFilterPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout((LayoutManager)new VerticalLayout(0));
        JPanel rowOnePanel = new JPanel((LayoutManager)new VariableRowHeightGridLayout(3));
        JPanel rowTwoPanel = new JPanel((LayoutManager)new VariableRowHeightGridLayout(0, 0, 2));
        MatchTypeFilter matchTypeFilter = new MatchTypeFilter();
        this.addFilter(matchTypeFilter);
        rowOnePanel.add(matchTypeFilter.getComponent());
        AssociationStatusFilter associationStatusFilter = new AssociationStatusFilter();
        this.addFilter(associationStatusFilter);
        rowOnePanel.add(associationStatusFilter.getComponent());
        rowOnePanel.getAccessibleContext().setAccessibleName("Match Type and Status");
        SymbolTypeFilter symbolTypeFilter = new SymbolTypeFilter();
        this.addFilter(symbolTypeFilter);
        rowTwoPanel.add(symbolTypeFilter.getComponent());
        AlgorithmFilter algorithmFilter = new AlgorithmFilter();
        this.addFilter(algorithmFilter);
        rowTwoPanel.add(algorithmFilter.getComponent());
        rowTwoPanel.getAccessibleContext().setAccessibleName("Symbol Type and Algorithm");
        MatchAddressRangeFilter addressRangeFilter = new MatchAddressRangeFilter();
        addressRangeFilter.getComponent().getAccessibleContext().setAccessibleName("Address Range");
        this.addFilter(addressRangeFilter);
        TagFilter tagFilter = new TagFilter(this.controller);
        tagFilter.getComponent().getAccessibleContext().setAccessibleName("Tag");
        this.addFilter(tagFilter);
        panel.add(rowOnePanel);
        panel.add(rowTwoPanel);
        panel.add(addressRangeFilter.getComponent());
        panel.add(tagFilter.getComponent());
        panel.getAccessibleContext().setAccessibleName("Match Filter");
        return panel;
    }
}

