/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.gui;

import docking.DialogComponentProvider;
import docking.theme.gui.ThemeUtils;
import docking.widgets.combobox.GhidraComboBox;
import generic.theme.GTheme;
import generic.theme.GThemeValueMap;
import generic.theme.ThemeManager;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CreateThemeDialog
extends DialogComponentProvider {
    private JTextField nameField;
    private ThemeManager themeManager;
    private GhidraComboBox<GTheme> combo;
    private GTheme newTheme;

    protected CreateThemeDialog(ThemeManager themeManager) {
        super("Create Theme");
        this.themeManager = themeManager;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    protected void okCallback() {
        String themeName = this.nameField.getText().trim();
        File file = ThemeUtils.getSaveFile((String)themeName);
        GTheme baseTheme = (GTheme)this.combo.getSelectedItem();
        this.newTheme = new GTheme(file, themeName, baseTheme.getLookAndFeelType(), baseTheme.useDarkDefaults());
        this.newTheme.load((GThemeValueMap)baseTheme);
        try {
            this.newTheme.save();
        }
        catch (IOException e) {
            Msg.showError(ThemeUtils.class, null, (String)"I/O Error", (Object)("Error writing theme file: " + this.newTheme.getFile().getAbsolutePath()), (Throwable)e);
            this.newTheme = null;
        }
        this.close();
    }

    protected void cancelCallback() {
        this.close();
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.nameField = this.createNameField();
        this.combo = this.buildThemeCombo();
        panel.add(new JLabel("New Theme Name: "));
        panel.add(this.nameField);
        panel.add(new JLabel("Base Theme: "));
        panel.add((Component)this.combo);
        return panel;
    }

    private JTextField createNameField() {
        JTextField jTextField = new JTextField(20);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateThemeDialog.this.updateOk();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateThemeDialog.this.updateOk();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CreateThemeDialog.this.updateOk();
            }
        });
        return jTextField;
    }

    private void updateOk() {
        String name = this.nameField.getText().trim();
        this.setOkEnabled(this.isValidThemeName(name));
    }

    private boolean isValidThemeName(String name) {
        if (name.isBlank()) {
            this.setStatusText("You must enter a theme name!");
            return false;
        }
        GTheme existing = this.themeManager.getTheme(name);
        if (existing != null) {
            this.setStatusText("Theme already exists with that name!");
            return false;
        }
        this.clearStatusText();
        return true;
    }

    private GhidraComboBox<GTheme> buildThemeCombo() {
        List supportedThemes = this.themeManager.getSupportedThemes();
        GhidraComboBox ghidraComboBox = new GhidraComboBox((Collection)supportedThemes);
        ghidraComboBox.setSelectedItem((Object)this.themeManager.getActiveTheme());
        return ghidraComboBox;
    }

    public GTheme getNewTheme(PluginTool tool, String suggestedName) {
        if (suggestedName != null) {
            this.nameField.setText(suggestedName);
            this.nameField.selectAll();
        }
        this.updateOk();
        tool.showDialog(this);
        return this.newTheme;
    }
}

