/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import generic.theme.GIcon;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;

public interface DomainFolder
extends Comparable<DomainFolder> {
    public static final Icon OPEN_FOLDER_ICON = new GIcon("icon.datatree.node.domain.folder.open");
    public static final Icon CLOSED_FOLDER_ICON = new GIcon("icon.datatree.node.domain.folder.closed");
    public static final String SEPARATOR = "/";
    public static final String COPY_SUFFIX = ".copy";

    public String getName();

    public DomainFolder setName(String var1) throws InvalidNameException, IOException;

    public ProjectLocator getProjectLocator();

    public ProjectData getProjectData();

    public String getPathname();

    public boolean isSame(DomainFolder var1);

    public boolean isSameOrAncestor(DomainFolder var1);

    public URL getSharedProjectURL();

    public URL getLocalProjectURL();

    public boolean isInWritableProject();

    public DomainFolder getParent();

    public DomainFolder[] getFolders();

    public DomainFolder getFolder(String var1);

    public DomainFile getFile(String var1);

    public boolean isEmpty();

    public DomainFile[] getFiles();

    public DomainFile createFile(String var1, DomainObject var2, TaskMonitor var3) throws InvalidNameException, IOException, CancelledException;

    public DomainFile createFile(String var1, File var2, TaskMonitor var3) throws InvalidNameException, IOException, CancelledException;

    public DomainFile createLinkFile(ProjectData var1, String var2, boolean var3, String var4, LinkHandler<?> var5) throws IOException;

    public DomainFile createLinkFile(String var1, String var2, LinkHandler<?> var3) throws IOException;

    public DomainFolder createFolder(String var1) throws InvalidNameException, IOException;

    public void delete() throws IOException;

    public DomainFolder moveTo(DomainFolder var1) throws IOException;

    public DomainFolder copyTo(DomainFolder var1, TaskMonitor var2) throws IOException, CancelledException;

    public DomainFile copyToAsLink(DomainFolder var1, boolean var2) throws IOException;

    public void setActive();

    default public boolean isLinked() {
        return false;
    }
}

