/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.extensions;

import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.theme.GAttributes;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.framework.plugintool.dialog.AbstractDetailsPanel;
import ghidra.framework.project.extensions.ExtensionTablePanel;
import ghidra.util.extensions.ExtensionDetails;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;

class ExtensionDetailsPanel
extends AbstractDetailsPanel {
    private static final GColor FG_COLOR_AUTHOR = new GColor("color.fg.extensionpanel.details.author");
    private static final GColor FG_COLOR_DATE = new GColor("color.fg.extensionpanel.details.date");
    private static final GColor FG_COLOR_DESCRIPTION = new GColor("color.fg.extensionpanel.details.description");
    private static final GColor FG_COLOR_NAME = new GColor("color.fg.extensionpanel.details.name");
    private static final GColor FG_COLOR_PATH = new GColor("color.fg.extensionpanel.path");
    private static final GColor FG_COLOR_TITLE = new GColor("color.fg.extensionpanel.details.title");
    private static final GColor FG_COLOR_VERSION = new GColor("color.fg.extensionpanel.details.version");
    private GAttributes nameAttrSet;
    private GAttributes descrAttrSet;
    private GAttributes authorAttrSet;
    private GAttributes createdOnAttrSet;
    private GAttributes versionAttrSet;
    private GAttributes pathAttrSet;
    private ExtensionDetails currentDetails;

    ExtensionDetailsPanel(final ExtensionTablePanel tablePanel) {
        this.createFieldAttributes();
        this.createMainPanel();
        tablePanel.getTableModel().addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadPending() {
            }

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                ExtensionDetailsPanel.this.setDescription(tablePanel.getSelectedItem());
            }
        });
        tablePanel.getTable().getSelectionModel().addListSelectionListener(e -> this.setDescription(tablePanel.getSelectedItem()));
    }

    @Override
    protected void refresh() {
        this.setDescription(this.currentDetails);
    }

    public void setDescription(ExtensionDetails details) {
        this.currentDetails = details;
        this.clear();
        if (details == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder("<html>");
        buffer.append("<TABLE cellpadding=2>");
        this.insertRowTitle(buffer, "Name");
        this.insertRowValue(buffer, details.getName(), this.nameAttrSet);
        this.insertRowTitle(buffer, "Description");
        this.insertRowValue(buffer, details.getDescription(), this.descrAttrSet);
        this.insertRowTitle(buffer, "Author");
        this.insertRowValue(buffer, details.getAuthor(), this.authorAttrSet);
        this.insertRowTitle(buffer, "Created-on");
        String date = details.getCreatedOn();
        this.insertRowValue(buffer, date, this.createdOnAttrSet);
        this.insertRowTitle(buffer, "Version");
        String version = details.getVersion();
        if (version.equals("@extversion@")) {
            this.insertRowValue(buffer, "", this.versionAttrSet);
        } else {
            this.insertRowValue(buffer, version, this.versionAttrSet);
        }
        String installPath = details.getInstallPath();
        if (installPath != null) {
            this.insertRowTitle(buffer, "Install Path");
            this.insertRowValue(buffer, installPath, this.pathAttrSet);
        }
        buffer.append("</TABLE>");
        this.textLabel.setText(buffer.toString());
        this.sp.getViewport().setViewPosition(new Point(0, 0));
    }

    @Override
    protected void createFieldAttributes() {
        Font font = Gui.getFont((String)"font.panel.details");
        titleAttrs = new GAttributes(font, (Color)FG_COLOR_TITLE);
        this.nameAttrSet = new GAttributes(font, (Color)FG_COLOR_NAME);
        this.descrAttrSet = new GAttributes(font, (Color)FG_COLOR_DESCRIPTION);
        this.authorAttrSet = new GAttributes(font, (Color)FG_COLOR_AUTHOR);
        this.createdOnAttrSet = new GAttributes(font, (Color)FG_COLOR_DATE);
        this.versionAttrSet = new GAttributes(font, (Color)FG_COLOR_VERSION);
        this.pathAttrSet = new GAttributes(font, (Color)FG_COLOR_PATH);
    }
}

