/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.features.codecompare.decompile.AbstractMatchedTokensAction;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonView;
import ghidra.features.codecompare.decompile.DualDecompilerActionContext;
import ghidra.features.codecompare.decompile.TokenPair;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Duo;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import java.awt.Component;

public class ApplyLocalNameFromMatchedTokensAction
extends AbstractMatchedTokensAction {
    private PluginTool tool;
    public static final String ACTION_NAME = "Function Comparison Apply Local Variable Name";
    private static final String MENU_GROUP = "A1_ApplyVariable";

    public ApplyLocalNameFromMatchedTokensAction(DecompilerCodeComparisonView comparisonProvider, PluginTool tool) {
        super(ACTION_NAME, tool.getName(), comparisonProvider, true);
        this.tool = tool;
        MenuData menuData = new MenuData(new String[]{"Apply From Other Function", "Variable Name"}, null, MENU_GROUP);
        this.setPopupMenuData(menuData);
        this.setHelpLocation(new HelpLocation("FunctionComparison", this.getName()));
    }

    @Override
    protected boolean isEnabledForDualDecompilerContext(DualDecompilerActionContext context) {
        ClangVariableToken leftVar;
        ClangToken clangToken;
        block7: {
            block6: {
                TokenPair tokenPair = context.getTokenPair();
                if (tokenPair == null) {
                    return false;
                }
                if (tokenPair.leftToken() == null || tokenPair.rightToken() == null) {
                    return false;
                }
                clangToken = tokenPair.leftToken();
                if (!(clangToken instanceof ClangVariableToken)) break block6;
                leftVar = (ClangVariableToken)clangToken;
                clangToken = tokenPair.rightToken();
                if (clangToken instanceof ClangVariableToken) break block7;
            }
            return false;
        }
        ClangVariableToken rightVar = (ClangVariableToken)clangToken;
        HighSymbol leftSymbol = leftVar.getHighSymbol(context.getHighFunction(Duo.Side.LEFT));
        HighSymbol rightSymbol = rightVar.getHighSymbol(context.getHighFunction(Duo.Side.RIGHT));
        if (leftSymbol == null || rightSymbol == null) {
            return false;
        }
        return !leftSymbol.isGlobal() && !rightSymbol.isGlobal();
    }

    @Override
    public void dualDecompilerActionPerformed(DualDecompilerActionContext context) {
        TokenPair currentPair = context.getTokenPair();
        Duo.Side activeSide = this.comparisonProvider.getActiveSide();
        ClangVariableToken activeToken = activeSide == Duo.Side.LEFT ? (ClangVariableToken)currentPair.leftToken() : (ClangVariableToken)currentPair.rightToken();
        ClangVariableToken otherToken = activeSide == Duo.Side.LEFT ? (ClangVariableToken)currentPair.rightToken() : (ClangVariableToken)currentPair.leftToken();
        HighSymbol activeHighSymbol = activeToken.getHighSymbol(context.getHighFunction(activeSide));
        HighSymbol otherHighSymbol = otherToken.getHighSymbol(context.getHighFunction(activeSide.otherSide()));
        Function activeFunction = context.getCodeComparisonView().getFunction(activeSide);
        Program activeProgram = activeFunction.getProgram();
        try {
            activeProgram.withTransaction("Code Comparison Apply Local Variable Name", () -> HighFunctionDBUtil.updateDBVariable((HighSymbol)activeHighSymbol, (String)otherHighSymbol.getName(), null, (SourceType)SourceType.IMPORTED));
        }
        catch (DuplicateNameException e) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Duplicate Name", (Object)("Name " + otherHighSymbol.getName() + " already exists in function " + activeFunction.getName()));
        }
        catch (UsrException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }
}

