/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.LocationClangHighlightController;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonOptions;
import ghidra.features.codecompare.decompile.DiffClangHighlightListener;
import ghidra.features.codecompare.graphanalysis.TokenBin;
import ghidra.util.ColorUtils;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import util.CollectionUtils;

public class DiffClangHighlightController
extends LocationClangHighlightController
implements DiffClangHighlightListener {
    private Set<ClangToken> diffTokenSet = new HashSet<ClangToken>();
    private ClangToken locationToken;
    private TokenBin locationTokenBin;
    private List<TokenBin> highlightBins;
    private List<DiffClangHighlightListener> listenerList = new ArrayList<DiffClangHighlightListener>();
    private TokenBin matchingTokenBin;
    private DecompilerCodeComparisonOptions comparisonOptions;

    public DiffClangHighlightController(DecompilerCodeComparisonOptions comparisonOptions) {
        this.comparisonOptions = comparisonOptions;
    }

    public void clearDiffHighlights() {
        this.doClearDiffHighlights();
        this.notifyListeners();
    }

    private void doClearDiffHighlights() {
        ClangToken[] array;
        for (ClangToken clangToken : array = this.diffTokenSet.toArray(new ClangToken[this.diffTokenSet.size()])) {
            this.clearDiffHighlight(clangToken);
        }
    }

    private void clearDiffHighlight(ClangToken clangToken) {
        Color highlight = clangToken.getHighlight();
        if (highlight != null && highlight.equals(this.comparisonOptions.getDiffHighlightColor())) {
            clangToken.setHighlight(null);
        }
        this.diffTokenSet.remove(clangToken);
    }

    private void clearNonDiffHighlight(ClangToken clangToken) {
        if (this.diffTokenSet.contains(clangToken)) {
            clangToken.setHighlight(this.comparisonOptions.getDiffHighlightColor());
        } else {
            clangToken.setHighlight(null);
        }
        if (clangToken.isMatchingToken()) {
            clangToken.setMatchingToken(false);
        }
    }

    public void setDiffHighlights(List<TokenBin> highlightBins, Set<ClangToken> tokenSet) {
        this.highlightBins = highlightBins;
        this.doClearDiffHighlights();
        for (ClangToken clangToken : tokenSet) {
            clangToken.setHighlight(this.comparisonOptions.getDiffHighlightColor());
            this.diffTokenSet.add(clangToken);
        }
        this.notifyListeners();
    }

    public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
        if (!(field instanceof ClangTextField)) {
            return;
        }
        ClangToken tok = ((ClangTextField)field).getToken(location);
        if (SystemUtilities.isEqual((Object)this.locationToken, (Object)tok)) {
            return;
        }
        if (this.matchingTokenBin != null && this.matchingTokenBin.getMatch() != null) {
            this.clearTokenBinHighlight(this.matchingTokenBin.getMatch());
            this.matchingTokenBin = null;
        }
        this.clearCurrentLocationHighlight();
        this.clearPrimaryHighlights();
        this.addPrimaryHighlight(tok, this.defaultHighlightColor);
        if (tok instanceof ClangSyntaxToken) {
            List tokens = this.addPrimaryHighlightToTokensForParenthesis((ClangSyntaxToken)tok, this.defaultParenColor);
            this.reHighlightDiffs(tokens);
            this.addPrimaryHighlightToTokensForBrace((ClangSyntaxToken)tok, this.defaultParenColor);
        }
        TokenBin tokenBin = null;
        if (tok != null) {
            Color highlightColor = this.comparisonOptions.getFocusedTokenIneligibleHighlightColor();
            if (this.highlightBins != null && (tokenBin = TokenBin.getBinContainingToken(this.highlightBins, tok)) != null) {
                if (tokenBin.getMatch() != null) {
                    highlightColor = this.comparisonOptions.getFocusedTokenMatchHighlightColor();
                } else if (tokenBin.getMatch() == null) {
                    highlightColor = this.comparisonOptions.getFocusedTokenUnmatchedHighlightColor();
                } else {
                    tokenBin = null;
                }
            }
            this.locationToken = tok;
            this.locationTokenBin = tokenBin;
            if (tokenBin == null) {
                this.addPrimaryHighlight(tok, highlightColor);
            } else {
                this.addTokenBinHighlight(tokenBin, highlightColor);
            }
        }
        for (DiffClangHighlightListener listener : this.listenerList) {
            listener.locationTokenChanged(tok, tokenBin);
        }
    }

    private void reHighlightDiffs(List<ClangToken> tokenList) {
        Color averageColor = ColorUtils.blend((Color)this.defaultParenColor, (Color)this.comparisonOptions.getDiffHighlightColor(), (double)0.5);
        for (ClangToken clangToken : tokenList) {
            if (!this.diffTokenSet.contains(clangToken)) continue;
            clangToken.setHighlight(averageColor);
        }
    }

    private void clearCurrentLocationHighlight() {
        if (this.locationTokenBin != null) {
            this.clearTokenBinHighlight(this.locationTokenBin);
            this.locationTokenBin = null;
            this.locationToken = null;
        }
        if (this.locationToken != null) {
            this.clearNonDiffHighlight(this.locationToken);
            this.locationToken = null;
        }
    }

    private void addTokenBinHighlight(TokenBin tokenBin, Color highlightColor) {
        for (ClangToken token : tokenBin) {
            this.addPrimaryHighlight(token, highlightColor);
        }
    }

    private void clearTokenBinHighlight(TokenBin tokenBin) {
        for (ClangToken token : tokenBin) {
            this.clearNonDiffHighlight(token);
        }
    }

    private void doClearHighlights(TokenHighlights tokens) {
        List clangTokens = CollectionUtils.asStream((Iterable[])new Iterable[]{tokens}).map(ht -> ht.getToken()).collect(Collectors.toList());
        for (ClangToken clangToken : clangTokens) {
            this.clearNonDiffHighlight(clangToken);
        }
        tokens.clear();
        this.notifyListeners();
    }

    public void clearPrimaryHighlights() {
        this.doClearHighlights(this.getPrimaryHighlights());
    }

    public boolean addListener(DiffClangHighlightListener listener) {
        return this.listenerList.add(listener);
    }

    public boolean removeListener(DiffClangHighlightListener listener) {
        return this.listenerList.remove(listener);
    }

    @Override
    public void locationTokenChanged(ClangToken tok, TokenBin tokenBin) {
        this.clearCurrentLocationHighlight();
        this.highlightMatchingToken(tok, tokenBin);
    }

    private void highlightMatchingToken(ClangToken tok, TokenBin tokenBin) {
        if (this.matchingTokenBin != null && this.matchingTokenBin.getMatch() != null) {
            this.clearTokenBinHighlight(this.matchingTokenBin.getMatch());
        }
        if (tokenBin != null && tokenBin.getMatch() != null) {
            this.addTokenBinHighlight(tokenBin.getMatch(), this.comparisonOptions.getFocusedTokenMatchHighlightColor());
        }
        this.matchingTokenBin = tokenBin;
    }
}

