/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph;

import ghidra.app.util.viewer.listingpanel.ProgramLocationTranslator;
import ghidra.features.codecompare.functiongraph.FgDisplay;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Duo;

class FgDisplaySynchronizer {
    private Duo<FgDisplay> displays;
    private ProgramLocationTranslator locationTranslator;

    FgDisplaySynchronizer(Duo<FgDisplay> displays, ListingAddressCorrelation correlation) {
        this.displays = displays;
        this.locationTranslator = new ProgramLocationTranslator(correlation);
    }

    void setLocation(Duo.Side side, ProgramLocation location) {
        Duo.Side otherSide = side.otherSide();
        ProgramLocation otherLocation = this.locationTranslator.getProgramLocation(otherSide, location);
        if (otherLocation != null) {
            ((FgDisplay)this.displays.get(otherSide)).setLocation(otherLocation);
        }
    }

    void sync(Duo.Side side) {
        ProgramLocation programLocation = ((FgDisplay)this.displays.get(side)).getLocation();
        if (programLocation != null) {
            this.setLocation(side, programLocation);
        }
    }

    void dispose() {
    }
}

