/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntBinOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitBinOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public interface BitwiseBinOpGen<T extends JitBinOp>
extends IntBinOpGen<T> {
    @Override
    default public boolean isSigned() {
        return false;
    }

    public int intOpcode();

    public int longOpcode();

    default public void generateMpIntBinOp(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int legCount = type.legsAlloc();
        try (JitAllocationModel.JvmTempAlloc result = gen.getAllocationModel().allocateTemp(mv, "result", legCount);){
            OpGen.generateMpLegsIntoTemp(result, legCount, mv);
            for (int i = 0; i < legCount; ++i) {
                mv.visitVarInsn(21, result.idx(i));
                mv.visitInsn(this.intOpcode());
                mv.visitVarInsn(54, result.idx(i));
            }
            OpGen.generateMpLegsFromTemp(result, legCount, mv);
        }
    }

    @Override
    default public JitType afterLeft(JitCodeGenerator gen, T op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniform(gen, lType, rType, TypeConversions.Ext.ZERO, rv);
    }

    @Override
    default public JitType generateBinOpRunCode(JitCodeGenerator gen, T op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniform(gen, rType, lType, TypeConversions.Ext.ZERO, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)jitType2;
                    rv.visitInsn(this.intOpcode());
                    break block6;
                }
                case 1: {
                    JitType.LongJitType t = (JitType.LongJitType)jitType2;
                    rv.visitInsn(this.longOpcode());
                    break block6;
                }
                case 2: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    if (t.size() != lType.size()) {
                        n = 3;
                        continue block6;
                    }
                    this.generateMpIntBinOp(gen, t, rv);
                    break block6;
                }
                case 3: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    Unfinished.TODO((String)"MpInt of differing sizes", (Object[])new Object[0]);
                    break block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return rType;
    }
}

