/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.gen.FieldForExitSlot;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitBranchOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.RegisterValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public enum BranchOpGen implements OpGen<JitBranchOp>
{
    GEN;


    static void generateRetireCode(JitCodeGenerator gen, Address exit, RegisterValue ctx, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        gen.generatePassageExit(block, () -> rv.visitLdcInsn((Object)exit.getOffset()), ctx, rv);
    }

    static void generateExitCode(JitCodeGenerator gen, Address exit, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        BranchOpGen.generateRetireCode(gen, exit, null, block, rv);
        rv.visitInsn(1);
        rv.visitInsn(176);
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitBranchOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        JitPassage.RBranch rBranch = op.branch();
        Objects.requireNonNull(rBranch);
        JitPassage.RBranch rBranch2 = rBranch;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitPassage.RIntBranch.class, JitPassage.RExtBranch.class}, (Object)rBranch2, n)) {
            case 0: {
                JitPassage.RIntBranch ib = (JitPassage.RIntBranch)rBranch2;
                IntBranchGen.INT.generateCode(gen, op, ib, block, rv);
                break;
            }
            case 1: {
                JitPassage.RExtBranch eb = (JitPassage.RExtBranch)rBranch2;
                ExtBranchGen.EXT.generateCode(gen, op, eb, block, rv);
                break;
            }
            default: {
                throw new AssertionError((Object)"Branch type confusion");
            }
        }
    }

    static class IntBranchGen
    extends BranchGen<JitPassage.RIntBranch, JitOp> {
        static final IntBranchGen INT = new IntBranchGen();

        IntBranchGen() {
        }

        @Override
        Address exit(JitCodeGenerator gen, JitPassage.RIntBranch branch) {
            return gen.getAddressForOp(branch.to());
        }

        @Override
        void generateCodeWithoutCtxmod(JitCodeGenerator gen, JitOp op, JitPassage.RIntBranch branch, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            JitControlFlowModel.JitBlock target = block.getTargetBlock(branch);
            Label label = gen.labelForBlock(target);
            VarGen.computeBlockTransition(gen, block, target).generate(rv);
            rv.visitJumpInsn(167, label);
        }

        @Override
        void generateCodeWithCtxmod(JitCodeGenerator gen, JitOp op, Address exit, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            BranchOpGen.generateExitCode(gen, exit, block, rv);
        }
    }

    static class ExtBranchGen
    extends BranchGen<JitPassage.RExtBranch, JitOp> {
        static final ExtBranchGen EXT = new ExtBranchGen();

        ExtBranchGen() {
        }

        @Override
        Address exit(JitCodeGenerator gen, JitPassage.RExtBranch branch) {
            return branch.to().address;
        }

        @Override
        void generateCodeWithoutCtxmod(JitCodeGenerator gen, JitOp op, JitPassage.RExtBranch branch, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            JitPassage.AddrCtx exit = branch.to();
            FieldForExitSlot slotField = gen.requestFieldForExitSlot(exit);
            BranchOpGen.generateRetireCode(gen, exit.address, exit.rvCtx, block, rv);
            slotField.generateLoadCode(gen, rv);
            rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "getChained", GenConsts.MDESC_JIT_COMPILED_PASSAGE__GET_CHAINED, true);
            rv.visitInsn(176);
        }

        @Override
        void generateCodeWithCtxmod(JitCodeGenerator gen, JitOp op, Address exit, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            BranchOpGen.generateExitCode(gen, exit, block, rv);
        }
    }

    static abstract class BranchGen<TB extends JitPassage.RBranch, TO extends JitOp> {
        BranchGen() {
        }

        abstract Address exit(JitCodeGenerator var1, TB var2);

        abstract void generateCodeWithoutCtxmod(JitCodeGenerator var1, TO var2, TB var3, JitControlFlowModel.JitBlock var4, MethodVisitor var5);

        abstract void generateCodeWithCtxmod(JitCodeGenerator var1, TO var2, Address var3, JitControlFlowModel.JitBlock var4, MethodVisitor var5);

        void generateCode(JitCodeGenerator gen, TO op, TB branch, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            switch (branch.reach()) {
                case WITH_CTXMOD: {
                    this.generateCodeWithCtxmod(gen, op, this.exit(gen, branch), block, rv);
                    break;
                }
                case WITHOUT_CTXMOD: {
                    this.generateCodeWithoutCtxmod(gen, op, branch, block, rv);
                    break;
                }
                case MAYBE_CTXMOD: {
                    Label withModctx = new Label();
                    JitAllocationModel.RunFixedLocal.CTXMOD.generateLoadCode(rv);
                    rv.visitJumpInsn(154, withModctx);
                    this.generateCodeWithoutCtxmod(gen, op, branch, block, rv);
                    rv.visitLabel(withModctx);
                    this.generateCodeWithCtxmod(gen, op, this.exit(gen, branch), block, rv);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }
}

