/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractLongOffsetPcodeExecutorStatePiece<A, T, S>
implements PcodeExecutorStatePiece<A, T> {
    protected final Language language;
    protected final PcodeArithmetic<A> addressArithmetic;
    protected final PcodeArithmetic<T> arithmetic;
    protected final PcodeStateCallbacks cb;
    protected final AddressSpace uniqueSpace;

    protected static <S> void forkMap(Map<AddressSpace, S> into, Map<AddressSpace, S> from, Function<S, S> forker) {
        for (Map.Entry<AddressSpace, S> ent : from.entrySet()) {
            into.put(ent.getKey(), forker.apply(ent.getValue()));
        }
    }

    public AbstractLongOffsetPcodeExecutorStatePiece(Language language, PcodeArithmetic<A> addressArithmetic, PcodeArithmetic<T> arithmetic, PcodeStateCallbacks cb) {
        this.language = language;
        this.addressArithmetic = addressArithmetic;
        this.arithmetic = arithmetic;
        this.cb = cb;
        this.uniqueSpace = language.getAddressFactory().getUniqueSpace();
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public PcodeArithmetic<A> getAddressArithmetic() {
        return this.addressArithmetic;
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return Stream.of(this);
    }

    protected void setUnique(long offset, int size, T val, PcodeStateCallbacks cb) {
        S s = this.getForSpace(this.uniqueSpace, true);
        this.setInSpace(s, offset, size, val, cb);
    }

    protected T getUnique(long offset, int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        S s = this.getForSpace(this.uniqueSpace, false);
        return this.getFromSpace(s, offset, size, reason, cb);
    }

    protected abstract S getForSpace(AddressSpace var1, boolean var2);

    protected abstract void setInSpace(S var1, long var2, int var4, T var5, PcodeStateCallbacks var6);

    protected abstract T getFromSpace(S var1, long var2, int var4, PcodeExecutorStatePiece.Reason var5, PcodeStateCallbacks var6);

    protected T getFromNullSpace(int size, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        return this.arithmetic.fromConst(0, size);
    }

    protected void setVarInternal(AddressSpace space, long offset, int size, boolean quantize, T val, PcodeStateCallbacks cb) {
        if (space.isConstantSpace()) {
            throw new IllegalArgumentException("Cannot write to constant space");
        }
        if (space.isUniqueSpace()) {
            this.setUnique(offset, size, val, cb);
            return;
        }
        S s = this.getForSpace(space, true);
        if (quantize) {
            offset = this.quantizeOffset(space, offset);
        }
        this.setInSpace(s, offset, size, val, cb);
    }

    @Override
    public void setVar(AddressSpace space, A offset, int size, boolean quantize, T val) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.STORE);
        this.setVar(space, lOffset, size, quantize, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, A offset, int size, T val) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.STORE);
        this.setVarInternal(space, lOffset, size, val);
    }

    protected T checkSize(int size, T val) {
        int valSize = (int)this.arithmetic.sizeOf(val);
        if (valSize > size) {
            throw new IllegalArgumentException("Value is larger than variable: " + valSize + " > " + size);
        }
        if (valSize < size) {
            Msg.warn((Object)this, (Object)("Value is smaller than variable: " + valSize + " < " + size + ". Zero extending"));
            val = this.arithmetic.unaryOp(17, size, valSize, val);
        }
        return val;
    }

    @Override
    public void setVar(AddressSpace space, long offset, int size, boolean quantize, T val) {
        this.checkRange(space, offset, size);
        val = this.checkSize(size, val);
        this.setVarInternal(space, offset, size, quantize, val, this.cb);
    }

    @Override
    public void setVarInternal(AddressSpace space, long offset, int size, T val) {
        this.setVarInternal(space, offset, size, false, val, PcodeStateCallbacks.NONE);
    }

    protected T getVarInternal(AddressSpace space, long offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason, PcodeStateCallbacks cb) {
        if (space.isConstantSpace()) {
            return this.arithmetic.fromConst(offset, size);
        }
        if (space.isUniqueSpace()) {
            return this.getUnique(offset, size, reason, cb);
        }
        S s = this.getForSpace(space, false);
        if (s == null) {
            AddressSet set = PcodeStateCallbacks.rngSet(space, offset, size);
            if (set.equals((Object)cb.readUninitialized(this, (AddressSetView)set))) {
                return this.getFromNullSpace(size, reason, cb);
            }
            s = this.getForSpace(space, false);
            if (s == null) {
                return this.getFromNullSpace(size, reason, cb);
            }
        }
        if (quantize) {
            offset = this.quantizeOffset(space, offset);
        }
        return this.getFromSpace(s, offset, size, reason, cb);
    }

    @Override
    public T getVar(AddressSpace space, A offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
        return this.getVar(space, lOffset, size, quantize, reason);
    }

    @Override
    public T getVarInternal(AddressSpace space, A offset, int size, PcodeExecutorStatePiece.Reason reason) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
        return this.getVarInternal(space, lOffset, size, reason);
    }

    @Override
    public T getVar(AddressSpace space, long offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        this.checkRange(space, offset, size);
        return this.getVarInternal(space, offset, size, quantize, reason, this.cb);
    }

    @Override
    public T getVarInternal(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.getVarInternal(space, offset, size, false, reason, PcodeStateCallbacks.NONE);
    }

    protected abstract Map<Register, T> getRegisterValuesFromSpace(S var1, List<Register> var2);

    @Override
    public Map<Register, T> getRegisterValues() {
        Map<AddressSpace, List<Register>> regsBySpace = this.language.getRegisters().stream().collect(Collectors.groupingBy(Register::getAddressSpace));
        HashMap<Register, T> result = new HashMap<Register, T>();
        for (Map.Entry<AddressSpace, List<Register>> ent : regsBySpace.entrySet()) {
            S s = this.getForSpace(ent.getKey(), false);
            if (s == null) continue;
            result.putAll(this.getRegisterValuesFromSpace(s, ent.getValue()));
        }
        return result;
    }
}

