/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.jung.renderer.FGEdgeRenderer;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.AbstractFlowChartLayout;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import java.util.Comparator;

public class FGFlowChartLayout
extends AbstractFlowChartLayout<FGVertex, FGEdge>
implements FGLayout {
    private FunctionGraphOptions options;

    protected FGFlowChartLayout(FunctionGraph graph, boolean leftAligned) {
        super(graph, new FGEdgeComparator(), leftAligned);
        this.options = graph.getOptions();
    }

    @Override
    public FunctionGraph getVisualGraph() {
        return (FunctionGraph)super.getVisualGraph();
    }

    public AbstractVisualGraphLayout<FGVertex, FGEdge> createClonedLayout(VisualGraph<FGVertex, FGEdge> newGraph) {
        return new FGFlowChartLayout((FunctionGraph)newGraph, this.leftAligned);
    }

    @Override
    public FGLayout cloneLayout(VisualGraph<FGVertex, FGEdge> newGraph) {
        VisualGraphLayout clone = super.cloneLayout(newGraph);
        return (FGLayout)clone;
    }

    protected boolean isCondensedLayout() {
        return this.options.useCondensedLayout();
    }

    public BasicEdgeRenderer<FGVertex, FGEdge> getEdgeRenderer() {
        return new FGEdgeRenderer();
    }

    @Override
    protected FGVertex getRoot(VisualGraph<FGVertex, FGEdge> g) {
        Graph graph = this.graph;
        if (graph instanceof FunctionGraph) {
            FunctionGraph fg = (FunctionGraph)graph;
            return fg.getRootVertex();
        }
        return null;
    }

    private static class FGEdgeComparator
    implements Comparator<FGEdge> {
        private FGEdgeComparator() {
        }

        @Override
        public int compare(FGEdge e1, FGEdge e2) {
            return this.priority(e1).compareTo(this.priority(e2));
        }

        private Integer priority(FGEdge e) {
            FlowType type = e.getFlowType();
            if (type == RefType.FALL_THROUGH) {
                return 1;
            }
            return 10;
        }
    }
}

