/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import ghidra.app.cmd.data.exceptionhandling.CreateEHFuncInfoBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.EHFunctionInfoModel;
import ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin.PEUtil;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.bytesource.ProgramByteSource;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.matcher.RegExByteMatcher;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.features.base.memsearch.searcher.MemorySearcher;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class PEExceptionAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Windows x86 PE Exception Handling";
    private static final String DESCRIPTION = "Marks up exception handling data structures within a Visual Studio windows PE program.";
    private static final int MATCH_LIMIT = Integer.MAX_VALUE;
    private static final int MAX_MAP_ENTRY_COUNT = 16000;

    public PEExceptionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after().after());
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return PEUtil.isVisualStudioOrClangPe(program);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        List ehBlocks = ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)set, (String)".rdata", (TaskMonitor)monitor);
        if (ehBlocks.isEmpty()) {
            ehBlocks = ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)set, (String)".text", (TaskMonitor)monitor);
        }
        String lePattern = "[\\x20,\\x21,\\x22]\\x05\\x93[\\x19,\\x39,\\x59,\\x79,\\x99,\\xb9,\\xd9,\\xf9]";
        String bePattern = "[\\x19,\\x39,\\x59,\\x79,\\x99,\\xb9,\\xd9,\\xf9]\\x93\\x05[\\x20,\\x21,\\x22]";
        String pattern = program.getLanguage().isBigEndian() ? bePattern : lePattern;
        int alignment = 4;
        SearchSettings settings = new SearchSettings().withAlignment(alignment);
        settings = settings.withIncludeInstructions(false);
        RegExByteMatcher matcher = new RegExByteMatcher(pattern, settings);
        ProgramByteSource byteSource = new ProgramByteSource(program);
        Memory memory = program.getMemory();
        AddressSet addresses = memory.getLoadedAndInitializedAddressSet().intersect(set);
        addresses = this.getAddressSet(ehBlocks).intersect((AddressSetView)addresses);
        MemorySearcher searcher = new MemorySearcher((AddressableByteSource)byteSource, (ByteMatcher)matcher, (AddressSetView)addresses, Integer.MAX_VALUE);
        ListAccumulator accumulator = new ListAccumulator();
        searcher.findAll((Accumulator)accumulator, monitor);
        List results = accumulator.asList();
        DataValidationOptions validationOptions = new DataValidationOptions();
        DataApplyOptions applyOptions = new DataApplyOptions();
        monitor.setMaximum((long)results.size());
        int count = 0;
        for (MemoryMatch match : results) {
            monitor.setProgress((long)count++);
            if (monitor.isCancelled()) {
                return false;
            }
            Address address = match.getAddress();
            if (address.getOffset() % (long)alignment != 0L) continue;
            EHFunctionInfoModel model = new EHFunctionInfoModel(program, address, validationOptions);
            try {
                model.validate();
                model.validateCounts(16000);
                model.validateLocationsInSameBlock();
                CreateEHFuncInfoBackgroundCmd cmd = new CreateEHFuncInfoBackgroundCmd(address, validationOptions, applyOptions);
                cmd.applyTo((DomainObject)program);
            }
            catch (InvalidDataTypeException invalidDataTypeException) {}
        }
        return true;
    }

    private AddressSet getAddressSet(List<MemoryBlock> blocks) {
        AddressSet addressSet = new AddressSet();
        for (MemoryBlock memoryBlock : blocks) {
            addressSet.add(memoryBlock.getStart(), memoryBlock.getEnd());
        }
        return addressSet;
    }
}

