/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.trable;

import docking.DockingUtils;
import docking.widgets.trable.GTrableCellClickedListener;
import docking.widgets.trable.GTrableCellRenderer;
import docking.widgets.trable.GTrableColumn;
import docking.widgets.trable.GTrableColumnModel;
import docking.widgets.trable.GTrableModeRowlListener;
import docking.widgets.trable.GTrableRowModel;
import docking.widgets.trable.OpenCloseIcon;
import ghidra.util.datastruct.Range;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;

public class GTrable<T>
extends JComponent
implements Scrollable,
GTrableModeRowlListener {
    private static final int ICON_WIDTH = 16;
    private static final int INDENT_WIDTH = 12;
    private static final int DEFAULT_MAX_VISIBLE_ROWS = 10;
    private static final int DEFAULT_MIN_VISIBLE_ROWS = 10;
    private static OpenCloseIcon OPEN_ICON = new OpenCloseIcon(true, 16, 16);
    private static OpenCloseIcon CLOSED_ICON = new OpenCloseIcon(false, 16, 16);
    private Color selectionForground = UIManager.getColor("List.selectionForeground");
    private Color selectionBackground = UIManager.getColor("List.selectionBackground");
    private int minVisibleRows = 10;
    private int maxVisibleRows = 10;
    private int rowHeight = 20;
    private GTrableRowModel<T> rowModel;
    private GTrableColumnModel<T> columnModel;
    private CellRendererPane renderPane;
    private int selectedRow = -1;
    private List<GTrableCellClickedListener> cellClickedListeners = new ArrayList<GTrableCellClickedListener>();
    private List<Consumer<Integer>> selectedRowConsumers = new ArrayList<Consumer<Integer>>();

    public GTrable(GTrableRowModel<T> rowModel, GTrableColumnModel<T> columnModel) {
        this.rowModel = rowModel;
        this.columnModel = columnModel;
        this.rowModel.addListener(this);
        this.renderPane = new CellRendererPane();
        this.add(this.renderPane);
        GTrableMouseListener l = new GTrableMouseListener();
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
        this.addKeyListener(new GTrableKeyListener());
        this.setFocusable(true);
    }

    public void setRowModel(GTrableRowModel<T> newRowModel) {
        this.rowModel.removeListener(this);
        this.rowModel = newRowModel;
        newRowModel.addListener(this);
    }

    public void setColumnModel(GTrableColumnModel<T> columnModel) {
        this.columnModel = columnModel;
    }

    public void setPreferredVisibleRowCount(int minVisibleRows, int maxVisibleRows) {
        this.minVisibleRows = minVisibleRows;
        this.maxVisibleRows = maxVisibleRows;
    }

    public void addCellClickedListener(GTrableCellClickedListener listener) {
        this.cellClickedListeners.add(listener);
    }

    public void removeCellClickedListener(GTrableCellClickedListener listener) {
        this.cellClickedListeners.remove(listener);
    }

    public void addSelectedRowConsumer(Consumer<Integer> consumer) {
        this.selectedRowConsumers.add(consumer);
    }

    public void removeSelectedRowConsumer(Consumer<Integer> consumer) {
        this.selectedRowConsumers.remove(consumer);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.columnModel.getPreferredWidth(), this.rowModel.getRowCount() * this.rowHeight);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        int startIndex = this.getStartIndex(clipBounds);
        int endIndex = this.getEndIndex(clipBounds);
        for (int index = startIndex; index <= endIndex; ++index) {
            this.drawRow(g, index);
        }
    }

    public Range getVisibleRows() {
        Rectangle rect;
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            rect = viewport.getViewRect();
        } else {
            rect = this.getVisibleRect();
        }
        return new Range(this.getStartIndex(rect), this.getEndIndex(rect));
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.rowModel.getRowCount()) {
            this.selectedRow = rowIndex;
            this.repaint();
            this.notifySelectedRowConsumers();
        }
    }

    public void clearSelectedRow() {
        this.selectedRow = -1;
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.selectionForground;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowOffcut() {
        Rectangle visibleRect = this.getVisibleRect();
        int y = visibleRect.y;
        return y % this.rowHeight;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int size = Math.min(this.rowModel.getRowCount(), this.maxVisibleRows);
        size = Math.max(size, this.minVisibleRows);
        return new Dimension(this.columnModel.getPreferredWidth(), size * this.rowHeight);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void expandRow(int rowIndex) {
        int numRowsAdded = this.rowModel.expandRow(rowIndex);
        if (this.selectedRow > rowIndex) {
            this.setSelectedRow(this.selectedRow + numRowsAdded);
        }
    }

    public void collapseRow(int rowIndex) {
        int numRowsDeleted = this.rowModel.collapseRow(rowIndex);
        if (this.selectedRow > rowIndex) {
            int newSelectedRow = this.selectedRow - numRowsDeleted;
            if (newSelectedRow < rowIndex) {
                newSelectedRow = rowIndex;
            }
            this.setSelectedRow(newSelectedRow);
        }
    }

    public void expandRowRecursively(int rowIndex) {
        int startIndentLevel = this.rowModel.getIndentLevel(rowIndex);
        int numRowsAdded = this.rowModel.expandRow(rowIndex);
        if (this.selectedRow > rowIndex) {
            this.setSelectedRow(this.selectedRow + numRowsAdded);
        }
        for (int nextRow = rowIndex + 1; nextRow < this.rowModel.getRowCount() && this.rowModel.getIndentLevel(nextRow) > startIndentLevel; ++nextRow) {
            numRowsAdded = this.rowModel.expandRow(nextRow);
            if (this.selectedRow <= nextRow) continue;
            this.setSelectedRow(this.selectedRow + numRowsAdded);
        }
    }

    public void expandAll() {
        int rowIndex = 0;
        for (rowIndex = 0; rowIndex < this.rowModel.getRowCount(); ++rowIndex) {
            int indentLevel = this.rowModel.getIndentLevel(rowIndex);
            if (indentLevel != 0) continue;
            this.expandRowRecursively(rowIndex);
        }
    }

    public void collapseAll() {
        int rowIndex = 0;
        for (rowIndex = 0; rowIndex < this.rowModel.getRowCount(); ++rowIndex) {
            int indentLevel = this.rowModel.getIndentLevel(rowIndex);
            if (indentLevel != 0) continue;
            this.collapseRow(rowIndex);
        }
    }

    public void scrollToSelectedRow() {
        if (this.selectedRow < 0) {
            return;
        }
        Container parent = this.getParent();
        if (!(parent instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)parent;
        Rectangle viewRect = viewport.getViewRect();
        int yStart = this.selectedRow * this.rowHeight;
        int yEnd = yStart + this.rowHeight;
        if (yStart < viewRect.y) {
            viewport.setViewPosition(new Point(0, yStart));
        } else if (yEnd > viewRect.y + viewRect.height) {
            viewport.setViewPosition(new Point(0, yEnd - viewRect.height));
        }
    }

    @Override
    public void trableChanged() {
        this.setSize(this.getWidth(), this.rowModel.getRowCount() * this.rowHeight);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.columnModel.setWidth(width);
    }

    public int getRow(Point p) {
        return p.y / this.rowHeight;
    }

    private void notifySelectedRowConsumers() {
        for (Consumer<Integer> consumer : this.selectedRowConsumers) {
            consumer.accept(this.selectedRow);
        }
    }

    private void notifyCellClicked(int row, int column, MouseEvent e) {
        for (GTrableCellClickedListener listener : this.cellClickedListeners) {
            listener.cellClicked(row, column, e);
        }
    }

    private void drawRow(Graphics g, int rowIndex) {
        int marginWidth;
        T row = this.rowModel.getRow(rowIndex);
        int width = this.getWidth();
        boolean isSelected = rowIndex == this.selectedRow;
        int y = rowIndex * this.rowHeight;
        Color fg = isSelected ? this.selectionForground : this.getForeground();
        Color bg = isSelected ? this.selectionBackground : this.getBackground();
        g.setColor(bg);
        g.fillRect(0, y, width, this.rowHeight);
        GTrableColumn<T, ?> firstColumn = this.columnModel.getColumn(0);
        int colWidth = firstColumn.getWidth();
        int x = marginWidth = this.paintLeftMargin(g, rowIndex, y, colWidth, fg);
        this.paintColumn(g, x, y, colWidth - marginWidth, firstColumn, row, isSelected);
        x = colWidth;
        for (int i = 1; i < this.columnModel.getColumnCount(); ++i) {
            GTrableColumn<T, ?> column = this.columnModel.getColumn(i);
            colWidth = column.getWidth();
            this.paintColumn(g, x, y, colWidth, column, row, isSelected);
            x += colWidth;
        }
    }

    private <C> void paintColumn(Graphics g, int x, int y, int width, GTrableColumn<T, C> column, T row, boolean isSelected) {
        GTrableCellRenderer<C> renderer = column.getRenderer();
        C columnValue = column.getValue(row);
        Component component = renderer.getCellRenderer(this, columnValue, isSelected, false, 0, 0);
        this.renderPane.paintComponent(g, component, this, x, y, width, this.rowHeight);
    }

    private int paintLeftMargin(Graphics g, int rowIndex, int y, int width, Color fg) {
        int x = this.rowModel.getIndentLevel(rowIndex) * 12;
        this.drawOpenCloseControl(g, rowIndex, x, y, fg);
        return x + 16;
    }

    private void drawOpenCloseControl(Graphics g, int rowIndex, int x, int y, Color fg) {
        if (!this.rowModel.isExpandable(rowIndex)) {
            return;
        }
        OpenCloseIcon icon = this.rowModel.isExpanded(rowIndex) ? OPEN_ICON : CLOSED_ICON;
        icon.setColor(fg);
        icon.paintIcon(this, g, x, y + this.rowHeight / 2 - icon.getIconHeight() / 2);
    }

    private int getStartIndex(Rectangle clipBounds) {
        if (clipBounds.height == 0) {
            return 0;
        }
        int index = clipBounds.y / this.rowHeight;
        return Math.min(index, this.rowModel.getRowCount() - 1);
    }

    private int getEndIndex(Rectangle clipBounds) {
        if (clipBounds.height == 0) {
            return 0;
        }
        int y = clipBounds.y + clipBounds.height - 1;
        return Math.min(y / this.rowHeight, this.rowModel.getRowCount() - 1);
    }

    private void toggleOpen(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        if (!this.rowModel.isExpandable(rowIndex)) {
            return;
        }
        if (this.rowModel.isExpanded(rowIndex)) {
            this.collapseRow(rowIndex);
        } else {
            this.expandRow(rowIndex);
        }
    }

    private class GTrableMouseListener
    extends MouseAdapter {
        private static final int TRIGGER_MARGIN = 10;
        private int startDragX = -1;
        private int originalColumnStart;
        private int boundaryIndex;

        private GTrableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            Point point = e.getPoint();
            int rowIndex = point.y / GTrable.this.rowHeight;
            if (this.isOnOpenClose(rowIndex, point.x)) {
                GTrable.this.toggleOpen(rowIndex);
            } else {
                int columnIndex = this.getColumnIndex(rowIndex, point.x);
                if (columnIndex >= 0) {
                    GTrable.this.notifyCellClicked(rowIndex, columnIndex, e);
                }
            }
        }

        private int getColumnIndex(int rowIndex, int x) {
            int indent;
            int columnIndex = GTrable.this.columnModel.getIndex(x);
            if (columnIndex == 0 && x < (indent = GTrable.this.rowModel.getIndentLevel(rowIndex) * 12)) {
                return -1;
            }
            return columnIndex;
        }

        private boolean isOnOpenClose(int rowIndex, int x) {
            if (!GTrable.this.rowModel.isExpandable(rowIndex)) {
                return false;
            }
            int indent = GTrable.this.rowModel.getIndentLevel(rowIndex) * 12;
            return x >= indent && x < indent + 16;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            int rowIndex = p.y / GTrable.this.rowHeight;
            if (e.getButton() == 1 && this.isOnOpenClose(rowIndex, p.x)) {
                return;
            }
            int index = this.findClosestColumnBoundary(e.getPoint().x);
            if (index >= 0) {
                this.boundaryIndex = index;
                this.startDragX = e.getPoint().x;
                this.originalColumnStart = GTrable.this.columnModel.getColumn(index).getStartX();
                return;
            }
            if (DockingUtils.isControlModifier(e) && rowIndex == GTrable.this.selectedRow) {
                GTrable.this.clearSelectedRow();
            } else {
                GTrable.this.setSelectedRow(rowIndex);
            }
        }

        public int findClosestColumnBoundary(int x) {
            for (int i = 1; i < GTrable.this.columnModel.getColumnCount(); ++i) {
                GTrableColumn column = GTrable.this.columnModel.getColumn(i);
                int columnStart = column.getStartX();
                if (x <= columnStart - 10 || x >= columnStart + 10) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int index = this.findClosestColumnBoundary(e.getPoint().x);
            if (index >= 0) {
                GTrable.this.setCursor(Cursor.getPredefinedCursor(11));
            } else {
                GTrable.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.startDragX = -1;
            this.boundaryIndex = -1;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.startDragX < 0) {
                return;
            }
            int x = e.getPoint().x;
            int diff = x - this.startDragX;
            int newColumnStart = this.originalColumnStart + diff;
            GTrable.this.columnModel.moveColumnStart(this.boundaryIndex, newColumnStart);
            GTrable.this.repaint();
        }
    }

    private class GTrableKeyListener
    extends KeyAdapter {
        private GTrableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 40: {
                    if (GTrable.this.selectedRow >= GTrable.this.rowModel.getRowCount() - 1) break;
                    GTrable.this.setSelectedRow(GTrable.this.selectedRow + 1);
                    GTrable.this.scrollToSelectedRow();
                    e.consume();
                    break;
                }
                case 38: {
                    if (GTrable.this.selectedRow <= 0) break;
                    GTrable.this.setSelectedRow(GTrable.this.selectedRow - 1);
                    GTrable.this.scrollToSelectedRow();
                    e.consume();
                    break;
                }
                case 10: {
                    GTrable.this.toggleOpen(GTrable.this.selectedRow);
                    e.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 40: {
                    if (GTrable.this.selectedRow >= GTrable.this.rowModel.getRowCount() - 1) break;
                    e.consume();
                    break;
                }
                case 38: {
                    if (GTrable.this.selectedRow <= 0) break;
                    e.consume();
                    break;
                }
                case 10: {
                    e.consume();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 40: {
                    if (GTrable.this.selectedRow >= GTrable.this.rowModel.getRowCount() - 1) break;
                    e.consume();
                    break;
                }
                case 38: {
                    if (GTrable.this.selectedRow <= 0) break;
                    e.consume();
                    break;
                }
                case 10: {
                    e.consume();
                }
            }
        }
    }
}

