/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go.ipc;

import ghidra.app.plugin.core.go.exception.StartedGhidraProcessExitedException;
import ghidra.app.plugin.core.go.exception.StopWaitingException;
import ghidra.app.plugin.core.go.ipc.CheckPeriodicallyRunnable;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CheckForListenerRunnable
extends CheckPeriodicallyRunnable {
    public static int WAIT_FOR_LISTENER_DELAY_MS = 30000;
    public static int WAIT_FOR_LISTENER_PERIOD_MS = 60000;
    public static int MAX_WAIT_FOR_LISTENER_MIN = 5;
    private Process process;
    private StopWaitingException stopWaitingException;
    private StartedGhidraProcessExitedException startedGhidraProcessExitedException;

    public CheckForListenerRunnable(Process p, int period, TimeUnit timeUnit, Callable<Boolean> checkCondition) {
        super(false, period, timeUnit, checkCondition);
        this.process = p;
    }

    private CheckForListenerRunnable(ScheduledExecutorService executor, Process p, int period, TimeUnit timeUnit, Callable<Boolean> checkCondition) {
        super(executor, true, period, timeUnit, checkCondition);
        this.process = p;
    }

    @Override
    public void run() {
        try {
            if (((Boolean)this.checkCondition.call()).booleanValue()) {
                try {
                    this.checkProcessDidNotExit(this.process);
                    if (this.showDialog) {
                        Msg.info((Object)this, (Object)"Waiting for GhidraGo to listen for new files...");
                        dialog.showDialog();
                    }
                    this.executor.schedule(this, (long)this.period, this.timeUnit);
                }
                catch (StopWaitingException e) {
                    this.stopWaitingException = e;
                    this.dispose();
                }
                catch (StartedGhidraProcessExitedException e) {
                    this.startedGhidraProcessExitedException = e;
                    this.dispose();
                }
                catch (RejectedExecutionException e) {
                    this.dispose();
                }
            } else {
                this.dispose();
            }
        }
        catch (Exception e) {
            Swing.runNow(() -> Msg.showError((Object)this, null, (String)"GhidraGo Unable to Check For Listener", (Object)"GhidraGo could not check for a listener.", (Throwable)e));
            this.dispose();
        }
    }

    private void checkProcessDidNotExit(Process p) throws StartedGhidraProcessExitedException {
        if (p != null) {
            try {
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    throw new StartedGhidraProcessExitedException(exitValue);
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void startChecking(int delay, TimeUnit delayTimeUnit) throws StopWaitingException {
        block2: {
            dialog.reset();
            try {
                super.startChecking(delay, delayTimeUnit);
                this.executor.schedule(new CheckForListenerRunnable(this.executor, this.process, WAIT_FOR_LISTENER_PERIOD_MS, TimeUnit.MILLISECONDS, (Callable<Boolean>)this.checkCondition), (long)WAIT_FOR_LISTENER_DELAY_MS, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!dialog.isAnsweredNo()) break block2;
                throw new StopWaitingException();
            }
        }
    }

    @Override
    public void awaitTermination() throws StopWaitingException, StartedGhidraProcessExitedException {
        try {
            this.executor.awaitTermination(MAX_WAIT_FOR_LISTENER_MIN, TimeUnit.MINUTES);
            if (dialog.isAnsweredNo()) {
                throw new StopWaitingException();
            }
            if (this.stopWaitingException != null) {
                throw this.stopWaitingException;
            }
            if (this.startedGhidraProcessExitedException != null) {
                throw this.startedGhidraProcessExitedException;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

