/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.program.model.pcode.Varnode;
import java.io.Serializable;

public class Handle
implements Serializable {
    public static final int SPACE = 0;
    public static final int OFFSET = 1;
    public static final int SIZE = 2;
    private Varnode ptr;
    private int spaceID;
    private int size;

    public Handle(Varnode p, int sp, int sz) {
        this.ptr = p;
        this.spaceID = sp;
        this.size = sz;
    }

    public long getLong(int select1, int select2) {
        switch (select1) {
            case 0: {
                return this.spaceID;
            }
            case 1: {
                try {
                    switch (select2) {
                        case 0: {
                            return this.ptr.getSpace();
                        }
                        case 1: {
                            return this.ptr.getOffset();
                        }
                        case 2: {
                            return this.ptr.getSize();
                        }
                    }
                    return 0L;
                }
                catch (Exception e) {
                    return 0L;
                }
            }
            case 2: {
                return this.size;
            }
        }
        return 0L;
    }

    public long getSpace() {
        return this.spaceID;
    }

    public long getSize() {
        return this.size;
    }

    public Varnode getPtr() {
        return this.ptr;
    }

    public boolean isAddress() {
        int spaceType = 0xF & this.spaceID;
        return spaceType == 1;
    }

    @Deprecated
    public boolean isCodeAddress() {
        throw new UnsupportedOperationException();
    }

    public boolean isDataAddress() {
        int spaceType = 0xF & this.spaceID;
        return spaceType == 1;
    }

    public boolean isConstant() {
        int type = 0xF & this.spaceID;
        return type == 0;
    }

    public boolean isRegister() {
        int type = 0xF & this.spaceID;
        return type == 4;
    }

    public boolean isUnique() {
        int type = 0xF & this.spaceID;
        return type == 3;
    }

    public boolean dynamic() {
        return !this.ptr.isConstant();
    }
}

