/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.template;

import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeOp;
import java.util.ArrayList;

public class OpTpl {
    private VarnodeTpl output;
    private int opcode;
    private VarnodeTpl[] input;

    protected OpTpl() {
    }

    public OpTpl(int opcode, VarnodeTpl output, VarnodeTpl[] inputs) {
        this.opcode = opcode;
        this.output = output;
        this.input = inputs;
    }

    public VarnodeTpl getOutput() {
        return this.output;
    }

    public VarnodeTpl[] getInput() {
        return this.input;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void decode(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(SlaFormat.ELEM_OP_TPL);
        this.opcode = decoder.readOpcode(SlaFormat.ATTRIB_CODE);
        int outel = decoder.peekElement();
        if (outel == SlaFormat.ELEM_NULL.id()) {
            decoder.openElement();
            decoder.closeElement(outel);
            this.output = null;
        } else {
            this.output = new VarnodeTpl();
            this.output.decode(decoder);
        }
        ArrayList<VarnodeTpl> inputlist = new ArrayList<VarnodeTpl>();
        while (decoder.peekElement() != 0) {
            VarnodeTpl vn = new VarnodeTpl();
            vn.decode(decoder);
            inputlist.add(vn);
        }
        this.input = new VarnodeTpl[inputlist.size()];
        inputlist.toArray(this.input);
        decoder.closeElement(el);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.output != null) {
            sb.append(this.output);
            sb.append(" = ");
        }
        sb.append(PcodeOp.getMnemonic(this.opcode));
        boolean first = true;
        for (VarnodeTpl in : this.input) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(" ");
            sb.append(in);
        }
        return sb.toString();
    }
}

