/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.dialog;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.EmptyBorderButton;
import docking.widgets.textfield.IntegerTextField;
import generic.theme.GIcon;
import ghidra.app.services.GoToService;
import ghidra.features.bsim.gui.BSimServerManager;
import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.search.dialog.AbstractBSimSearchDialog;
import ghidra.features.bsim.gui.search.dialog.BSimFilterPanel;
import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;
import ghidra.features.bsim.gui.search.dialog.BSimSearchService;
import ghidra.features.bsim.gui.search.dialog.BSimSearchSettings;
import ghidra.features.bsim.gui.search.dialog.BSimServerCache;
import ghidra.features.bsim.gui.search.dialog.SelectedFunctionsTableDialog;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BSimSearchDialog
extends AbstractBSimSearchDialog {
    private static final Icon FUNCTIONS_ICON = new GIcon("icon.bsim.functions.table");
    protected Set<FunctionSymbol> selectedFunctions;
    private JTextField functionsField;
    private BSimFilterPanel filterPanel;
    private IntegerTextField maxResultsField;

    public BSimSearchDialog(PluginTool tool, BSimSearchService service, BSimServerManager serverManager, Set<FunctionSymbol> functions) {
        super("Bsim Search Dialog", tool, service, serverManager);
        this.selectedFunctions = functions;
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", "BSim_Search_Dialog"));
        this.setMinimumSize(500, 400);
        this.updateSearchFunctionsLabel();
        this.setOkButtonText("Search");
    }

    @Override
    protected void initializeSettings(BSimSearchSettings lastUsedSearchSettings) {
        super.initializeSettings(lastUsedSearchSettings);
        this.maxResultsField.setValue(lastUsedSearchSettings.getMaxResults());
        this.filterPanel.setFilterSet(lastUsedSearchSettings.getBSimFilterSet());
    }

    protected void okCallback() {
        this.searchService.search(this.serverCache, this.getSearchSettings(), this.selectedFunctions);
        this.close();
    }

    @Override
    protected void setServerCache(BSimServerCache serverCache) {
        super.setServerCache(serverCache);
        this.updateFilters();
    }

    protected void updateSearchFunctionsLabel() {
        if (this.selectedFunctions.isEmpty()) {
            this.functionsField.setText("<none>");
        } else if (this.selectedFunctions.size() == 1) {
            FunctionSymbol symbol = this.selectedFunctions.iterator().next();
            this.functionsField.setText(symbol.getName());
        } else {
            this.functionsField.setText(this.selectedFunctions.size() + " selected functions");
        }
    }

    @Override
    protected JPanel buildServerPanel() {
        JPanel panel = super.buildServerPanel();
        panel.add(new JLabel("Function(s): "));
        panel.add(this.buildSelectedFunctionPanel());
        return panel;
    }

    @Override
    protected JPanel buildCenterPanel() {
        this.filterPanel = new BSimFilterPanel(this::filterPanelChanged);
        return this.createTitledPanel("Filters:", this.filterPanel, true);
    }

    @Override
    protected boolean canQuery() {
        if (!super.canQuery()) {
            return false;
        }
        if (!this.filterPanel.hasValidFilters()) {
            this.setStatusText("One or more filters has invalid data!", MessageType.ERROR);
            return false;
        }
        this.clearStatusText();
        return true;
    }

    @Override
    protected JPanel buildOptionsPanel() {
        JPanel panel = super.buildOptionsPanel();
        this.maxResultsField = new IntegerTextField(10);
        this.maxResultsField.setValue(100);
        this.maxResultsField.setMinValue(BigInteger.ONE);
        this.maxResultsField.setAllowNegativeValues(false);
        this.maxResultsField.setAllowsHexPrefix(false);
        this.maxResultsField.setShowNumberMode(false);
        JComponent maxResultsComponent = this.maxResultsField.getComponent();
        JLabel maxLabel = new JLabel("Max Matches Per Function:");
        maxLabel.setLabelFor(maxResultsComponent);
        panel.add(maxLabel);
        panel.add(maxResultsComponent);
        return panel;
    }

    protected BSimSearchSettings getSearchSettings() {
        double similarity = this.similarityField.getValue();
        double confidence = this.confidenceField.getValue();
        int maxResults = this.maxResultsField.getIntValue();
        BSimFilterSet set = this.filterPanel.getFilterSet();
        return new BSimSearchSettings(similarity, confidence, maxResults, set);
    }

    private void updateFilters() {
        DatabaseInformation databaseInfo = this.getDatabaseInformation();
        List<BSimFilterType> filters = BSimFilterType.generateBsimFilters(databaseInfo, true);
        this.filterPanel.setFilters(filters);
    }

    private void filterPanelChanged() {
        this.updateSearchEnablement();
    }

    private Component buildSelectedFunctionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.functionsField = new JTextField(20);
        this.functionsField.setEditable(false);
        innerPanel.add((Component)this.functionsField, "Center");
        panel.add((Component)innerPanel, "Center");
        EmptyBorderButton button = new EmptyBorderButton(FUNCTIONS_ICON);
        button.setToolTipText("Show table of selected functions");
        button.addActionListener(e -> this.showSelectedFunctionsDialog());
        panel.add((Component)button, "East");
        return panel;
    }

    private void showSelectedFunctionsDialog() {
        if (this.selectedFunctions == null) {
            return;
        }
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        HelpLocation help = new HelpLocation("BSimSearchPlugin", "Selected_Functions");
        SelectedFunctionsTableDialog dialog = new SelectedFunctionsTableDialog(this.selectedFunctions, service, help);
        DockingWindowManager.showDialog((DialogComponentProvider)dialog);
    }

    Set<FunctionSymbol> getSelectedFunction() {
        return this.selectedFunctions;
    }

    BSimFilterPanel getFilterPanel() {
        return this.filterPanel;
    }
}

