/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.EmptyTextField;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutListener;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import docking.widgets.fieldpanel.support.ViewerPosition;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import generic.theme.Gui;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerIndexedView;
import ghidra.app.plugin.core.byteviewer.ByteViewerLayoutModel;
import ghidra.app.plugin.core.byteviewer.ByteViewerState;
import ghidra.app.plugin.core.byteviewer.IndexFieldFactory;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.PairLayout;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ByteViewerPanel
extends JPanel
implements LayoutModel,
LayoutListener {
    private static final String FONT_STATUS_ID = "font.byteviewer.status";
    private List<ByteViewerComponent> viewList;
    private FieldPanel indexPanel;
    private IndexFieldFactory indexFactory;
    private JLabel startField;
    private JLabel endField;
    private JLabel offsetField;
    private JLabel insertionField;
    private JPanel statusPanel;
    private int fontHeight;
    private FontMetrics fontMetrics;
    private int bytesPerLine;
    private ByteBlockSet blockSet;
    private ByteBlock[] blocks;
    private IndexMap indexMap;
    private int blockOffset;
    private ByteViewerComponent currentView;
    private Color editColor;
    private Color currentCursorColor;
    private Color currentCursorLineColor;
    private Color highlightColor;
    private int highlightButton;
    private List<LayoutModelListener> layoutListeners = new ArrayList<LayoutModelListener>(1);
    private boolean addingView;
    private final ByteViewerComponentProvider provider;
    private List<AddressSetDisplayListener> displayListeners = new ArrayList<AddressSetDisplayListener>();
    private ByteViewerIndexedView indexedView;

    protected ByteViewerPanel(ByteViewerComponentProvider provider) {
        this.provider = provider;
        this.bytesPerLine = 16;
        this.viewList = new ArrayList<ByteViewerComponent>();
        this.indexMap = new IndexMap();
        this.create();
        this.editColor = ByteViewerComponentProvider.CHANGED_VALUE_COLOR;
    }

    @Override
    public Dimension getPreferredSize() {
        int rowCount = 20;
        int rowsHeight = rowCount * this.fontHeight;
        int defaultHeight = rowsHeight + this.statusPanel.getHeight();
        if (this.viewList.isEmpty()) {
            int width = this.statusPanel.getPreferredSize().width + 20;
            return new Dimension(width, defaultHeight);
        }
        int width = this.indexPanel.getPreferredSize().width;
        int height = defaultHeight;
        for (ByteViewerComponent c : this.viewList) {
            Dimension d = c.getPreferredSize();
            width += d.width + 2;
            height = Math.max(d.height, defaultHeight);
        }
        return new Dimension(width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    void setCurrentCursorColor(Color c) {
        this.currentCursorColor = c;
        for (ByteViewerComponent comp : this.viewList) {
            comp.setCurrentCursorColor(c);
        }
    }

    void setCurrentCursorLineColor(Color c) {
        this.currentCursorLineColor = c;
        for (ByteViewerComponent comp : this.viewList) {
            comp.setCurrentCursorLineColor(c);
        }
    }

    void setHighlightButton(int highlightButton) {
        this.highlightButton = highlightButton;
        for (ByteViewerComponent comp : this.viewList) {
            comp.setHighlightButton(highlightButton);
        }
    }

    void setMouseButtonHighlightColor(Color color) {
        this.highlightColor = color;
        for (ByteViewerComponent comp : this.viewList) {
            comp.setMouseButtonHighlightColor(color);
        }
    }

    void setCursorColor(Color c) {
        for (ByteViewerComponent comp : this.viewList) {
            comp.setNonFocusCursorColor(c);
        }
    }

    void setSeparatorColor(Color c) {
        this.indexFactory.setMissingValueColor(c);
        for (ByteViewerComponent comp : this.viewList) {
            comp.setSeparatorColor(c);
        }
    }

    void setNonFocusCursorColor(Color c) {
        for (ByteViewerComponent comp : this.viewList) {
            comp.setNonFocusCursorColor(c);
        }
    }

    void setByteBlocks(ByteBlockSet blockSet) {
        this.blockSet = blockSet;
        this.blocks = null;
        this.indexMap = null;
        if (blockSet != null) {
            this.blocks = blockSet.getBlocks();
            if (this.blocks.length > 0) {
                this.indexMap = new IndexMap(blockSet, this.bytesPerLine, this.blockOffset);
                String start = this.blocks[0].getLocationRepresentation(BigInteger.ZERO);
                this.startField.setText(start);
                ByteBlock lastBlock = this.blocks[this.blocks.length - 1];
                this.endField.setText(lastBlock.getLocationRepresentation(lastBlock.getLength().subtract(BigInteger.ONE)));
                this.clearSelection();
            }
        }
        if (this.indexMap == null) {
            this.indexMap = new IndexMap();
        }
        this.indexFactory.setIndexMap(this.indexMap);
        this.indexFactory.setSize(this.getIndexSizeInChars());
        for (ByteViewerComponent c : this.viewList) {
            c.enableIndexUpdate(false);
            c.setIndexMap(this.indexMap);
        }
        for (ByteViewerComponent c : this.viewList) {
            c.enableIndexUpdate(true);
            c.setIndexMap(this.indexMap);
        }
        if (this.blocks != null && this.blocks.length > 0) {
            this.indexedView.setIndexName(this.blocks[0].getIndexName());
        }
        this.indexPanel.dataChanged(BigInteger.ZERO, this.indexMap.getNumIndexes());
        this.indexSetChanged();
    }

    void setViewerSelection(ByteBlockSelection selection) {
        for (ByteViewerComponent c : this.viewList) {
            c.setViewerSelection(selection);
        }
    }

    ByteBlockSelection getViewerSelection() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getViewerSelection();
    }

    void setViewerHighlight(ByteBlockSelection highlight) {
        for (ByteViewerComponent c : this.viewList) {
            c.setViewerHighlight(highlight);
        }
    }

    public void setViewerBackgroundColorModel(BackgroundColorModel colorModel) {
        for (ByteViewerComponent c : this.viewList) {
            c.setBackgroundColorModel(colorModel);
        }
    }

    ByteBlockSelection getViewerHighlight() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getViewerHighlight();
    }

    void setCursorLocation(ByteBlock block, BigInteger index, int column) {
        int modelIndex = -1;
        for (ByteViewerComponent c : this.viewList) {
            modelIndex = c.setViewerCursorLocation(block, index, column);
        }
        if (modelIndex >= 0) {
            this.insertionField.setText(block.getLocationRepresentation(index));
        }
    }

    ByteBlockInfo getCursorLocation() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getViewerCursorLocation();
    }

    DataFormatModel getCurrentModel() {
        if (this.currentView == null) {
            return null;
        }
        return this.currentView.getDataModel();
    }

    public ByteViewerComponent getCurrentComponent() {
        return this.currentView;
    }

    protected ByteViewerComponent newByteViewerComponent(DataFormatModel model) {
        return new ByteViewerComponent(this, new ByteViewerLayoutModel(), model, this.bytesPerLine, this.fontMetrics);
    }

    ByteViewerComponent addView(String viewName, DataFormatModel model, boolean editMode, boolean updateViewPosition) {
        if (this.viewList.size() != 0) {
            this.addingView = true;
        }
        ViewerPosition vp = this.getViewerPosition();
        ByteViewerComponent c = this.newByteViewerComponent(model);
        c.setEditColor(this.editColor);
        c.setNonFocusCursorColor((Color)ByteViewerComponentProvider.CURSOR_NOT_FOCUSED_COLOR);
        c.setCurrentCursorColor(this.currentCursorColor);
        c.setCurrentCursorLineColor(this.currentCursorLineColor);
        c.setEditMode(editMode);
        c.setIndexMap(this.indexMap);
        c.setMouseButtonHighlightColor(this.highlightColor);
        c.setHighlightButton(this.highlightButton);
        this.viewList.add(c);
        c.setSize(c.getPreferredSize());
        this.indexedView.addView(viewName, c);
        c.addListeners();
        if (this.viewList.size() == 1) {
            this.currentView = c;
            if (this.blocks != null) {
                this.setCursorLocation(this.blocks[0], BigInteger.ZERO, 0);
            }
        } else {
            ByteBlockInfo info;
            ByteBlockSelection hl;
            ByteBlockSelection sel = this.currentView.getViewerSelection();
            if (sel != null) {
                c.setViewerSelection(sel);
            }
            if ((hl = this.currentView.getViewerHighlight()) != null) {
                c.setViewerHighlight(hl);
            }
            if ((info = this.currentView.getViewerCursorLocation()) != null) {
                c.setViewerCursorLocation(info.getBlock(), info.getOffset(), info.getColumn());
            }
            if (updateViewPosition) {
                Swing.runLater(() -> this.indexPanel.setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset()));
            }
            this.addingView = false;
        }
        this.validate();
        this.repaint();
        return c;
    }

    void removeView(ByteViewerComponent comp) {
        this.viewList.remove((Object)comp);
        this.indexedView.removeView(comp);
        if (this.currentView == comp) {
            this.currentView = null;
        }
        if (this.viewList.size() > 0) {
            this.currentView = this.viewList.get(0);
        }
        comp.dispose();
        this.validate();
        this.repaint();
    }

    void setCurrentView(ByteViewerComponent c) {
        if (this.currentView != null && this.currentView != c) {
            this.currentView.setFocusedCursorColor(this.provider.getCursorColor());
        }
        this.currentView = c;
    }

    void setEditMode(boolean editMode) {
        for (ByteViewerComponent c : this.viewList) {
            c.setEditMode(editMode);
        }
    }

    boolean getEditMode() {
        if (this.currentView == null) {
            return false;
        }
        return this.currentView.getEditMode();
    }

    void refreshView() {
        for (ByteViewerComponent c : this.viewList) {
            c.refreshView();
        }
    }

    int getNumberOfViews() {
        return this.viewList.size();
    }

    void setOffset(int offset) {
        if (this.blockOffset != offset) {
            this.blockOffset = offset;
            this.updateIndexMap();
            this.offsetField.setText(Integer.toString(offset));
        }
    }

    void setBytesPerLine(int bytesPerLine) {
        if (this.bytesPerLine != bytesPerLine) {
            this.bytesPerLine = bytesPerLine;
            this.updateIndexMap();
        }
        this.indexedView.resetViewWidthToDefaults();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void checkBytesPerLine(int numBytesPerLine) throws InvalidInputException {
        for (ByteViewerComponent c : this.viewList) {
            DataFormatModel model = c.getDataModel();
            int groupSize = model.getGroupSize();
            if (groupSize <= 0 || numBytesPerLine % groupSize == 0) continue;
            throw new InvalidInputException("Bytes Per Line not divisible by Group Size[" + groupSize + "].");
        }
    }

    void setCurrentGroupSize(int groupSize) {
        if (this.currentView == null) {
            return;
        }
        ByteBlockInfo info = this.currentView.getViewerCursorLocation();
        this.currentView.setGroupSize(groupSize);
        if (info != null) {
            this.setCursorLocation(info.getBlock(), info.getOffset(), info.getColumn());
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void setInsertionField(ByteViewerComponent source, ByteBlock block, BigInteger offset, BigInteger modelIndex, int column, boolean isAltDown) {
        this.provider.updateLocation(block, offset, column, isAltDown);
        if (this.addingView) {
            return;
        }
        this.indexPanel.setCursorPosition(modelIndex, 0, 0, 0);
        if (block != null) {
            String locRep = block.getLocationRepresentation(offset);
            if (locRep == null) {
                return;
            }
            this.insertionField.setText(locRep);
        }
        for (ByteViewerComponent c : this.viewList) {
            if (source == c) continue;
            c.setViewerCursorLocation(block, offset, column);
        }
    }

    void updateSelection(ByteViewerComponent source, ByteBlockSelection selection) {
        this.provider.updateSelection(selection);
        for (ByteViewerComponent c : this.viewList) {
            if (source == c) continue;
            c.setViewerSelection(selection);
        }
    }

    void updateLiveSelection(ByteViewerComponent source, ByteBlockSelection selection) {
        this.provider.updateLiveSelection(selection);
    }

    FontMetrics getCurrentFontMetrics() {
        return this.fontMetrics;
    }

    List<String> getViewNamesInDisplayOrder() {
        return this.indexedView.getViewNamesInDisplayOrder();
    }

    public ViewerPosition getViewerPosition() {
        return this.indexPanel.getViewerPosition();
    }

    public void setViewerPosition(ViewerPosition pos) {
        this.indexPanel.setViewerPosition(pos.getIndex(), pos.getXOffset(), pos.getYOffset());
    }

    void restoreView(ByteViewerState vp) {
        if (this.currentView == null) {
            return;
        }
        ByteBlock block = vp.getBlock();
        BigInteger offset = vp.getOffset();
        ViewerPosition vpos = vp.getViewerPosition();
        for (ByteViewerComponent c : this.viewList) {
            c.returnToView(block, offset, vpos);
        }
        this.indexPanel.setViewerPosition(vpos.getIndex(), vpos.getXOffset(), vpos.getYOffset());
    }

    void restoreConfigState(FontMetrics metrics, Color newEditColor) {
        this.setFontMetrics(metrics);
        this.setEditColor(newEditColor);
    }

    void restoreConfigState(int newBytesPerLine, int offset) {
        if (this.blockOffset != offset) {
            this.blockOffset = offset;
            this.offsetField.setText(Integer.toString(offset));
            if (this.bytesPerLine == newBytesPerLine) {
                this.updateIndexMap();
            }
        }
        this.setBytesPerLine(newBytesPerLine);
    }

    void programWasRestored() {
        this.updateIndexMap();
        this.refreshView();
    }

    void setFontMetrics(FontMetrics fm) {
        this.fontMetrics = fm;
        for (ByteViewerComponent c : this.viewList) {
            c.setFontMetrics(fm);
        }
        this.indexFactory = new IndexFieldFactory(fm);
        this.indexFactory.setSize(this.getIndexSizeInChars());
        this.updateIndexMap();
        this.indexPanel.modelSizeChanged(IndexMapper.IDENTITY_MAPPER);
    }

    void setEditColor(Color editColor) {
        this.editColor = editColor;
        for (ByteViewerComponent c : this.viewList) {
            c.setEditColor(editColor);
        }
    }

    protected FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    protected int getBytesPerLine() {
        return this.bytesPerLine;
    }

    private void create() {
        this.setLayout(new BorderLayout(10, 0));
        this.fontMetrics = this.getFontMetrics(Gui.getFont((String)"font.byteviewer"));
        this.fontHeight = this.fontMetrics.getHeight();
        this.indexFactory = new IndexFieldFactory(this.fontMetrics);
        this.indexPanel = new FieldPanel((LayoutModel)this, "Byte Viewer");
        this.indexPanel.enableSelection(false);
        this.indexPanel.setCursorOn(false);
        this.indexPanel.setFocusable(false);
        this.indexPanel.addLayoutListener((LayoutListener)this);
        this.indexedView = new ByteViewerIndexedView(this.indexPanel);
        IndexedScrollPane indexedScrollPane = new IndexedScrollPane((JComponent)this.indexedView);
        indexedScrollPane.setWheelScrollingEnabled(false);
        indexedScrollPane.setColumnHeaderComp(this.indexedView.getColumnHeader());
        this.statusPanel = this.createStatusPanel();
        this.add((Component)indexedScrollPane, "Center");
        this.add((Component)this.statusPanel, "South");
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this, new HelpLocation("ByteViewerPlugin", "ByteViewerPlugin"));
    }

    private JPanel createStatusPanel() {
        GLabel startLabel = new GLabel("Start:", 4);
        GLabel endLabel = new GLabel("End:", 4);
        GLabel offsetLabel = new GLabel("Offset:", 4);
        GLabel insertionLabel = new GLabel("Insertion:", 4);
        this.startField = new GDLabel("00000000");
        this.startField.setName("Start");
        this.endField = new GDLabel("00000000");
        this.endField.setName("End");
        this.offsetField = new GDLabel("00000000");
        this.offsetField.setName("Offset");
        this.insertionField = new GDLabel("00000000");
        this.insertionField.setName("Insertion");
        Gui.registerFont((Component)startLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)endLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)offsetLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)insertionLabel, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.startField, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.endField, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.offsetField, (String)FONT_STATUS_ID);
        Gui.registerFont((Component)this.insertionField, (String)FONT_STATUS_ID);
        JPanel p1 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p1.add((Component)startLabel);
        p1.add(this.startField);
        JPanel p2 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p2.add((Component)endLabel);
        p2.add(this.endField);
        JPanel p3 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p3.add((Component)offsetLabel);
        p3.add(this.offsetField);
        JPanel p4 = new JPanel((LayoutManager)new PairLayout(0, 5));
        p4.add((Component)insertionLabel);
        p4.add(this.insertionField);
        JPanel[] panels = new JPanel[]{p1, p2, p3, p4};
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(10));
        for (JPanel element : panels) {
            panel.add(element);
        }
        panel.add(Box.createHorizontalStrut(10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        return panel;
    }

    private void updateIndexMap() {
        if (this.blockSet == null) {
            return;
        }
        ByteBlockInfo info = null;
        if (this.currentView != null) {
            info = this.currentView.getViewerCursorLocation();
        }
        this.indexMap = new IndexMap(this.blockSet, this.bytesPerLine, this.blockOffset);
        this.indexFactory.setIndexMap(this.indexMap);
        ByteBlock block = null;
        BigInteger offset = BigInteger.ZERO;
        if (info != null) {
            block = info.getBlock();
            offset = info.getOffset();
        }
        for (ByteViewerComponent c : this.viewList) {
            c.setIndexMap(this.indexMap);
            if (info == null) continue;
            c.setViewerCursorLocation(block, offset, info.getColumn());
        }
        this.indexSetChanged();
    }

    private void clearSelection() {
        for (ByteViewerComponent c : this.viewList) {
            c.clearViewerSelection();
        }
    }

    public boolean isUniform() {
        return true;
    }

    public Dimension getPreferredViewSize() {
        return new Dimension(100, 500);
    }

    public BigInteger getNumIndexes() {
        if (this.indexMap == null) {
            return BigInteger.ZERO;
        }
        return this.indexMap.getNumIndexes();
    }

    public Layout getLayout(BigInteger index) {
        Field field = this.indexFactory.getField(index);
        if (field == null) {
            int height = this.indexFactory.getMetrics().getMaxAscent() + this.indexFactory.getMetrics().getMaxDescent();
            field = new EmptyTextField(height, this.indexFactory.getStartX(), 0, this.indexFactory.getWidth());
        }
        return new SingleRowLayout(field);
    }

    public void addLayoutModelListener(LayoutModelListener listener) {
        this.layoutListeners.add(listener);
    }

    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.layoutListeners.remove(listener);
    }

    void indexSetChanged() {
        for (LayoutModelListener listener : this.layoutListeners) {
            listener.modelSizeChanged(IndexMapper.IDENTITY_MAPPER);
        }
    }

    private int getIndexSizeInChars() {
        int minChars = "Addresses".length();
        if (this.blocks != null) {
            for (ByteBlock element : this.blocks) {
                int charCount = element.getMaxLocationRepresentationSize();
                minChars = Math.max(minChars, charCount);
            }
        }
        return minChars;
    }

    public BigInteger getIndexAfter(BigInteger index) {
        BigInteger nextIndex = index.add(BigInteger.ONE);
        if (nextIndex.compareTo(this.indexMap.getNumIndexes()) >= 0) {
            return null;
        }
        return nextIndex;
    }

    public BigInteger getIndexBefore(BigInteger index) {
        if (index.equals(BigInteger.ZERO)) {
            return null;
        }
        return index.subtract(BigInteger.ONE);
    }

    public List<ByteViewerComponent> getViewList() {
        return this.viewList;
    }

    void setStatusMessage(String message) {
        this.provider.setStatusMessage(message);
    }

    public void flushChanges() {
    }

    protected AddressSetView computeVisibleAddresses(List<AnchoredLayout> layouts) {
        ByteViewerComponent component = this.getCurrentComponent();
        if (component == null || this.blockSet == null) {
            return new AddressSet();
        }
        BigInteger startIndex = layouts.get(0).getIndex();
        BigInteger endIndex = layouts.get(layouts.size() - 1).getIndex();
        FieldSelection fieldSel = new FieldSelection();
        fieldSel.addRange(startIndex, endIndex.add(BigInteger.ONE));
        ByteBlockSelection blockSel = component.processFieldSelection(fieldSel);
        return this.blockSet.getAddressSet(blockSel);
    }

    public void layoutsChanged(List<AnchoredLayout> layouts) {
        AddressSetView visible = this.computeVisibleAddresses(layouts);
        for (AddressSetDisplayListener listener : this.displayListeners) {
            try {
                listener.visibleAddressesChanged(visible);
            }
            catch (Throwable t) {
                Msg.showError((Object)this, (Component)this.indexPanel, (String)"Error in Display Listener", (Object)"Exception encountered when notifying listeners of change in display", (Throwable)t);
            }
        }
    }

    public void addDisplayListener(AddressSetDisplayListener listener) {
        this.displayListeners.add(listener);
    }

    public void removeDisplayListener(AddressSetDisplayListener listener) {
        this.displayListeners.add(listener);
    }

    public int getViewWidth(String viewName) {
        return this.indexedView.getViewWidth(viewName);
    }

    public void setViewWidth(String viewName, int width) {
        this.indexedView.setColumnWidth(viewName, width);
    }
}

