/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.funcfixup;

import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFRegisterMappings;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=999)
public class StorageVerificationDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        boolean isEmptySignature;
        DWARFRegisterMappings regMappings = dfunc.getProgram().getRegisterMappings();
        boolean ignoreStorage = dfunc.getProgram().getImportOptions().isIgnoreParamStorage() || regMappings != null && regMappings.isUseFormalParameterStorage();
        boolean bl = isEmptySignature = dfunc.params.isEmpty() && dfunc.retval.isMissingStorage();
        if (regMappings == null || ignoreStorage || isEmptySignature) {
            dfunc.signatureCommitMode = DWARFFunction.CommitMode.FORMAL;
            return;
        }
        boolean storageIsGood = true;
        for (DWARFVariable param : dfunc.params) {
            if (param.isMissingStorage() && !param.isZeroByte()) {
                storageIsGood = false;
                break;
            }
            if (param.isLocationValidOnEntry()) continue;
            storageIsGood = false;
            break;
        }
        if (!storageIsGood) {
            dfunc.signatureCommitMode = DWARFFunction.CommitMode.FORMAL;
        }
    }
}

