/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomExportEntryExt
implements StructConverter {
    public static final int SIZE = 20;
    private int size;
    private int dreloc;
    private int sameList;
    private int reserved2;
    private int reserved3;

    public SomExportEntryExt(BinaryReader reader) throws IOException {
        this.size = reader.readNextInt();
        this.dreloc = reader.readNextInt();
        this.sameList = reader.readNextInt();
        this.reserved2 = reader.readNextInt();
        this.reserved3 = reader.readNextInt();
    }

    public int getSize() {
        return this.size;
    }

    public int getDreloc() {
        return this.dreloc;
    }

    public int getSameList() {
        return this.sameList;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public int getReserved3() {
        return this.reserved3;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("export_entry_ext", 20);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "size", "export symbol size, data only");
        struct.add(DWORD, "dreloc", "start of dreloc for this symbol");
        struct.add(DWORD, "same_list", "circular list of exports that have the same value");
        struct.add(DWORD, "reserved2", null);
        struct.add(DWORD, "reserved3", null);
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

