/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import generic.theme.GThemeDefaults;
import ghidra.test.processors.support.PCodeTestResults;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import resources.ResourceManager;

public class PCodeTestCombinedTestResults {
    public static final String FILENAME = "pcode_test_results";
    private static String XML_VERSION = "1";
    private static int CHAR_WIDTH = 6;
    private File xmlFile;
    private File htmlFile;
    private Map<String, Set<String>> ignoredJunitTestNames = new HashMap<String, Set<String>>();
    private Map<String, PCodeTestResults> combinedResults = new HashMap<String, PCodeTestResults>();

    PCodeTestCombinedTestResults(File reportsDir, boolean readExisting) throws IOException {
        this.xmlFile = new File(reportsDir, "pcode_test_results.xml");
        this.htmlFile = new File(reportsDir, "pcode_test_results.html");
        if (readExisting && this.xmlFile.exists()) {
            this.restoreFromXml();
        }
    }

    public PCodeTestResults getTestResults(String jUnitName, boolean create) {
        PCodeTestResults testResults = this.combinedResults.get(jUnitName);
        if (testResults == null && create) {
            testResults = new PCodeTestResults(jUnitName, (Predicate<String>)new IgnoreTestPredicate(jUnitName));
            this.combinedResults.put(jUnitName, testResults);
        }
        return testResults;
    }

    private void restoreFromXml() throws IOException {
        FileInputStream istream = new FileInputStream(this.xmlFile);
        BufferedInputStream bis = new BufferedInputStream(istream);
        try {
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document doc = sax.build((InputStream)bis);
            Element root = doc.getRootElement();
            if (!"PCODE_TESTS".equals(root.getName()) || !XML_VERSION.equals(root.getAttributeValue("VERSION"))) {
                return;
            }
            List elementList = root.getChildren(PCodeTestResults.TAG_NAME);
            for (Element element : elementList) {
                String jUnitName = PCodeTestResults.getJunitName(element);
                PCodeTestResults testResults = new PCodeTestResults(element, (Predicate<String>)new IgnoreTestPredicate(jUnitName));
                this.combinedResults.put(jUnitName, testResults);
            }
        }
        catch (JDOMException je) {
            throw new IOException("Invalid P-Code test results xml file: " + String.valueOf(this.xmlFile), je);
        }
        finally {
            istream.close();
        }
    }

    public void addIgnoredTests(String junitName, String ... testNames) {
        Set ignoredTestSet = this.ignoredJunitTestNames.computeIfAbsent(junitName, n -> new HashSet());
        for (String testName : testNames) {
            ignoredTestSet.add(testName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToXml() throws IOException {
        File dir = this.xmlFile.getParentFile();
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("Failed to created directory: " + String.valueOf(dir));
        }
        Element root = new Element("PCODE_TESTS");
        root.setAttribute("VERSION", XML_VERSION);
        for (String name : this.combinedResults.keySet()) {
            PCodeTestResults testResults = this.combinedResults.get(name);
            root.addContent((Content)testResults.saveToXml());
        }
        File tmpFile = new File(this.xmlFile.getParentFile(), this.xmlFile.getName() + ".new");
        tmpFile.delete();
        FileOutputStream ostream = new FileOutputStream(tmpFile);
        try (BufferedOutputStream bos = new BufferedOutputStream(ostream);){
            Document doc = new Document(root);
            GenericXMLOutputter xmlout = new GenericXMLOutputter();
            xmlout.output(doc, (OutputStream)bos);
        }
        File oldFile = null;
        if (this.xmlFile.exists()) {
            oldFile = new File(this.xmlFile.getParentFile(), this.xmlFile.getName() + ".bak");
            oldFile.delete();
            if (!this.xmlFile.renameTo(oldFile)) {
                throw new IOException("Failed to update: " + this.xmlFile.getAbsolutePath());
            }
        }
        if (!tmpFile.renameTo(this.xmlFile)) {
            if (oldFile != null) {
                oldFile.renameTo(this.xmlFile);
            }
            throw new IOException("Failed to update: " + this.xmlFile.getAbsolutePath());
        }
        Msg.info((Object)this, (Object)("XML results file updated: " + this.xmlFile.getAbsolutePath()));
        if (oldFile != null) {
            oldFile.delete();
        }
    }

    void copyResourceFile(String resourceName, PrintWriter w) throws IOException {
        String line;
        InputStream in = ResourceManager.getResourceAsStream((String)resourceName);
        if (in == null) {
            throw new FileNotFoundException("Resource not found: " + resourceName);
        }
        in = new BufferedInputStream(in);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            w.println(line);
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void saveToHTML() throws IOException {
        HashSet<NamedTestColumn> set;
        File dir = this.htmlFile.getParentFile();
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("Failed to created directory: " + String.valueOf(dir));
        }
        ArrayList<String> sortedJUnitTestNames = new ArrayList<String>();
        HashMap allTestNamesMap = new HashMap();
        HashMap<String, NamedTestColumn> namedTestColumnMap = new HashMap<String, NamedTestColumn>();
        for (PCodeTestResults unitTestResults : this.combinedResults.values()) {
            sortedJUnitTestNames.add(unitTestResults.getJUnitName());
            for (String groupTestName : unitTestResults.getGroupTestNames()) {
                NamedTestColumn namedTestColumn;
                void var10_13;
                int index = groupTestName.indexOf(46);
                String string = "";
                if (index >= 0) {
                    String string2 = groupTestName.substring(0, index);
                }
                if ((set = (HashSet<NamedTestColumn>)allTestNamesMap.get(var10_13)) == null) {
                    set = new HashSet<NamedTestColumn>();
                    allTestNamesMap.put(var10_13, set);
                }
                if ((namedTestColumn = (NamedTestColumn)namedTestColumnMap.get(groupTestName)) == null) {
                    namedTestColumn = new NamedTestColumn(groupTestName);
                    namedTestColumnMap.put(groupTestName, namedTestColumn);
                    set.add(namedTestColumn);
                }
                namedTestColumn.adjustWidth(unitTestResults.getTestResults(groupTestName, false));
            }
        }
        Object[] groupNames = allTestNamesMap.keySet().toArray(new String[allTestNamesMap.size()]);
        Arrays.sort(groupNames);
        HashMap<String, NamedTestColumn[]> allTestNamesByGroup = new HashMap<String, NamedTestColumn[]>();
        for (Object object : groupNames) {
            set = (Set)allTestNamesMap.get(object);
            Object[] namedTestColumns = set.toArray(new NamedTestColumn[set.size()]);
            Arrays.sort(namedTestColumns);
            allTestNamesByGroup.put((String)object, (NamedTestColumn[])namedTestColumns);
        }
        Collections.sort(sortedJUnitTestNames);
        File tmpFile = new File(this.xmlFile.getParentFile(), this.xmlFile.getName() + ".new");
        tmpFile.delete();
        PrintWriter w = new PrintWriter(tmpFile);
        try {
            this.copyResourceFile("pcodetest/chunk1.hinc", w);
            this.writeTableHeader(w, (String[])groupNames, allTestNamesByGroup);
            this.copyResourceFile("pcodetest/chunk2.hinc", w);
            int rownum = 1;
            for (String name : sortedJUnitTestNames) {
                PCodeTestResults testResults = this.combinedResults.get(name);
                this.writeTestSummaryRow(w, testResults, rownum++ % 2 == 1);
            }
            this.copyResourceFile("pcodetest/chunk3.hinc", w);
            boolean bl = true;
            for (String name : sortedJUnitTestNames) {
                boolean bl2;
                PCodeTestResults testResults = this.combinedResults.get(name);
                this.writeTestResultsRow(w, (String[])groupNames, allTestNamesByGroup, testResults, rownum++ % 2 == 1, bl2);
                bl2 = false;
            }
            this.copyResourceFile("pcodetest/chunk4.hinc", w);
        }
        finally {
            w.flush();
            w.close();
        }
        File oldFile = null;
        if (this.htmlFile.exists()) {
            oldFile = new File(this.htmlFile.getParentFile(), this.htmlFile.getName() + ".bak");
            oldFile.delete();
            if (!this.htmlFile.renameTo(oldFile)) {
                throw new IOException("Failed to update: " + this.htmlFile.getAbsolutePath());
            }
        }
        if (!tmpFile.renameTo(this.htmlFile)) {
            if (oldFile != null) {
                oldFile.renameTo(this.htmlFile);
            }
            throw new IOException("Failed to update: " + this.htmlFile.getAbsolutePath());
        }
        Msg.info((Object)this, (Object)("HTML results file updated: " + this.htmlFile.getAbsolutePath()));
        if (oldFile != null) {
            oldFile.delete();
        }
    }

    private void writeTableHeader(PrintWriter w, String[] groupNames, Map<String, NamedTestColumn[]> allTestNamesByGroup) {
        NamedTestColumn[] namedTestColumns;
        String groupName;
        int groupIndex;
        int[] groupWidth = new int[groupNames.length];
        w.println("<tr>");
        for (groupIndex = 0; groupIndex < groupNames.length; ++groupIndex) {
            groupName = groupNames[groupIndex];
            for (NamedTestColumn namedTestColumn : namedTestColumns = allTestNamesByGroup.get(groupName)) {
                int columnWidth = namedTestColumn.getColumnWidth();
                w.print("<td class=\"ResultHead\" align=\"center\" valign=\"bottom\">");
                w.print("<img src=\"X\" border=0 height=1 width=" + columnWidth + "><br>");
                w.print("<div class=\"r90\">");
                w.print(HTMLUtilities.friendlyEncodeHTML((String)namedTestColumn.getTestName()));
                w.println("</div></td>");
                int n = groupIndex;
                groupWidth[n] = groupWidth[n] + columnWidth;
            }
        }
        w.println("</tr><tr>");
        for (groupIndex = 0; groupIndex < groupNames.length; ++groupIndex) {
            groupName = groupNames[groupIndex];
            namedTestColumns = allTestNamesByGroup.get(groupName);
            w.print("<td class=\"GroupHead\" valign=\"middle\" colspan=\"" + namedTestColumns.length + "\" style=\"max-width:" + groupWidth[groupIndex] + ";\">&nbsp;");
            if (groupName.length() != 0) {
                w.print(HTMLUtilities.friendlyEncodeHTML((String)groupName));
            }
            w.println("</td>");
        }
        w.println("</tr>");
    }

    private void writeResultCount(PrintWriter w, int count, Color color) {
        if (count == 0) {
            w.print("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.GRAY) + "\">-</font>");
        } else {
            w.print("<font color=\"" + String.valueOf(color) + "\">" + Integer.toString(count) + "</font>");
        }
    }

    private void writeTestSummaryRow(PrintWriter w, PCodeTestResults testResults, boolean shaded) {
        String shadeStyle = "";
        if (shaded) {
            shadeStyle = " class=\"shade\"";
        }
        w.println("<tr" + shadeStyle + ">");
        w.print(" <td class=\"TestName\"><a href=\"../logs/" + testResults.getJUnitName() + ".log\" target=\"_log\">");
        w.print(testResults.getJUnitName());
        w.println("</a></td><td class=\"DateTime\">");
        String time = testResults.getTime();
        if (time == null) {
            time = "&nbsp;";
        }
        w.print(time);
        w.println("</td>");
        if (testResults.summaryHasIngestErrors || testResults.summaryHasRelocationErrors || testResults.summaryHasDisassemblyErrors) {
            w.print("<td align=\"center\" class=\"ResultSummary bad\">");
            if (testResults.summaryHasIngestErrors) {
                w.print("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">Ingest-Err</font><br>");
            }
            if (testResults.summaryHasRelocationErrors) {
                w.print("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">Reloc-Err</font><br>");
            }
            if (testResults.summaryHasDisassemblyErrors) {
                w.print("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">Dis-Err</font>");
            }
        } else {
            w.print("<td align=\"center\" class=\"ResultSummary " + this.getSummaryHighlightColorClass(testResults) + "\">");
            this.writeResultCount(w, testResults.summaryPassCount, (Color)GThemeDefaults.Colors.Palette.GREEN);
            w.print("/");
            this.writeResultCount(w, testResults.summaryIgnoreCount, (Color)GThemeDefaults.Colors.Palette.GRAY);
            w.print("/");
            this.writeResultCount(w, testResults.summaryFailCount, (Color)GThemeDefaults.Colors.Palette.RED);
            w.print("/");
            this.writeResultCount(w, testResults.summaryCallOtherCount, (Color)GThemeDefaults.Colors.Palette.ORANGE);
            if (testResults.summarySevereFailures != 0) {
                w.print("<br><font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">ERR:&nbsp;" + testResults.summarySevereFailures + "</font>");
            }
        }
        w.println("</td>");
        w.println("</tr>");
    }

    private String getSummaryHighlightColorClass(PCodeTestResults testResults) {
        int failCount = testResults.summaryFailCount;
        String summaryHighlight = "";
        int totalAsserts = testResults.summaryPassCount + failCount + testResults.summaryCallOtherCount;
        if (testResults.summarySevereFailures != 0 || totalAsserts != testResults.summaryTotalAsserts) {
            summaryHighlight = "bad";
            int diff = totalAsserts - (testResults.summaryPassCount + testResults.summaryCallOtherCount);
            if (diff > 0) {
                failCount = diff;
            }
        } else if (testResults.summaryPassCount != 0 && failCount == 0 && testResults.summaryCallOtherCount == 0) {
            summaryHighlight = "good";
        }
        return summaryHighlight;
    }

    private void writeTestResultsRow(PrintWriter w, String[] groupNames, Map<String, NamedTestColumn[]> allTestNamesByGroup, PCodeTestResults testResults, boolean shaded, boolean firstRow) {
        String shadeStyle = "";
        if (shaded) {
            shadeStyle = " class=\"shade\"";
        }
        w.println("<tr" + shadeStyle + ">");
        for (String groupName : groupNames) {
            NamedTestColumn[] namedTestColumns;
            for (NamedTestColumn namedTestColumn : namedTestColumns = allTestNamesByGroup.get(groupName)) {
                String testName = namedTestColumn.getTestName();
                int pass = testResults.getPassResult(groupName, testName);
                int ignored = testResults.getIgnoredResult(groupName, testName);
                int fail = testResults.getFailResult(groupName, testName);
                int callother = testResults.getCallOtherResult(groupName, testName);
                int total = pass + ignored + fail + callother;
                int totalAsserts = testResults.getTotalAsserts(groupName, testName);
                boolean severeFailure = testResults.hadSevereFailure(groupName, testName);
                boolean highlightBad = !severeFailure && total != 0 && total != totalAsserts;
                w.print(" <td align=\"center\" class=\"Result" + (highlightBad ? " bad" : "") + "\">");
                if (firstRow) {
                    w.print("<img src=\"X\" border=0 height=1 width=" + namedTestColumn.getColumnWidth() + "><br>");
                }
                if (severeFailure) {
                    w.print("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">ERR</font>");
                } else if (total == 0) {
                    if (totalAsserts == 0) {
                        w.print("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.GRAY) + "\">-</font>");
                    } else {
                        w.print("<font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">x</font>");
                    }
                } else {
                    this.writeResultCount(w, pass, (Color)GThemeDefaults.Colors.Palette.GREEN);
                    w.print("/");
                    this.writeResultCount(w, ignored, (Color)GThemeDefaults.Colors.Palette.GRAY);
                    w.print("/");
                    this.writeResultCount(w, fail, (Color)GThemeDefaults.Colors.Palette.RED);
                    w.print("/");
                    this.writeResultCount(w, callother, (Color)GThemeDefaults.Colors.Palette.ORANGE);
                    if (total != totalAsserts) {
                        w.print("<br><font color=\"" + String.valueOf(GThemeDefaults.Colors.Palette.RED) + "\">(!=" + totalAsserts + ")</font>");
                    }
                }
                w.println("</td>");
            }
        }
        w.println("</tr>");
    }

    private class IgnoreTestPredicate
    implements Predicate<String> {
        private String jUnitName;

        IgnoreTestPredicate(String jUnitName) {
            this.jUnitName = jUnitName;
        }

        @Override
        public boolean test(String testName) {
            Set<String> ignoredTestNames = PCodeTestCombinedTestResults.this.ignoredJunitTestNames.get(this.jUnitName);
            if (ignoredTestNames != null) {
                return ignoredTestNames.contains(testName);
            }
            return false;
        }
    }

    private static class NamedTestColumn
    implements Comparable<NamedTestColumn> {
        private final String groupTestName;
        private final String testName;
        int charCount = 5;

        NamedTestColumn(String groupTestName) {
            this.groupTestName = groupTestName;
            int index = groupTestName.indexOf(46);
            String testName = groupTestName;
            if (index >= 0) {
                testName = groupTestName.substring(index + 1);
            }
            this.testName = testName;
        }

        public String getGroupTestName() {
            return this.groupTestName;
        }

        public String getTestName() {
            return this.testName;
        }

        @Override
        public int compareTo(NamedTestColumn o) {
            return this.testName.compareTo(o.testName);
        }

        public int hashCode() {
            return this.testName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NamedTestColumn)) {
                return false;
            }
            NamedTestColumn other = (NamedTestColumn)obj;
            return this.testName.equals(other.testName);
        }

        public int getColumnWidth() {
            return (this.charCount + 2) * CHAR_WIDTH;
        }

        public void adjustWidth(PCodeTestResults.TestResults testResults) {
            if (testResults == null) {
                return;
            }
            int count = NamedTestColumn.computeCharCount(testResults.passCount) + NamedTestColumn.computeCharCount(testResults.ignoredCount) + NamedTestColumn.computeCharCount(testResults.failCount) + NamedTestColumn.computeCharCount(testResults.callOtherCount) + 2;
            this.charCount = Math.max(count, this.charCount);
        }

        private static int computeCharCount(int value) {
            int count = 1;
            while (value > 9) {
                ++count;
                value /= 10;
            }
            return count;
        }
    }
}

