/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.MnemonicFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;

public class PreviewTableCellData
implements Comparable<PreviewTableCellData> {
    private final int MAX_LINE_LENGTH = 500;
    private final Address address;
    private final ProgramLocation location;
    private final Program program;
    private CodeUnitFormat formatter;
    private String displayString;
    private String htmlDisplayString;
    private boolean isOffcut;

    public PreviewTableCellData(ProgramLocation location, CodeUnitFormat codeUnitFormat) {
        if (location == null) {
            throw new AssertException("ProgramLocation cannot be null");
        }
        this.location = location;
        this.program = location.getProgram();
        if (this.program == null) {
            throw new AssertException("Program cannot be null");
        }
        if (codeUnitFormat == null) {
            throw new AssertException("CodeUnitFormat cannot be null");
        }
        this.formatter = codeUnitFormat;
        this.address = location.getByteAddress();
        this.isOffcut = this.determineIsOffcut();
    }

    private boolean determineIsOffcut() {
        if (this.address.isExternalAddress()) {
            return false;
        }
        Listing listing = this.program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(this.address);
        if (cu == null) {
            return false;
        }
        if (cu instanceof Data) {
            Data data = (Data)cu;
            if ((data = data.getPrimitiveAt((int)this.address.subtract(data.getMinAddress()))) != null) {
                return !data.getMinAddress().equals((Object)this.address);
            }
        }
        return !cu.getMinAddress().equals((Object)this.address);
    }

    public boolean isOffcut() {
        return this.isOffcut;
    }

    private CodeUnit getCodeUnitContaining(Address addr) {
        Listing listing = this.program.getListing();
        CodeUnit cu = listing.getCodeUnitAt(addr);
        if (cu == null && (cu = listing.getCodeUnitContaining(addr)) instanceof Data) {
            Data data = (Data)cu;
            return data.getPrimitiveAt((int)addr.subtract(data.getMinAddress()));
        }
        return cu;
    }

    private String getPreview(CodeUnit cu, boolean htmlFriendly) {
        String preview = this.getFormatedCodeUnitPreview(cu);
        if (preview == null || preview.length() == 0) {
            preview = "??";
        }
        if (htmlFriendly) {
            if (preview.length() > 500) {
                preview = preview.substring(0, 500);
            }
            preview = HTMLUtilities.friendlyEncodeHTML((String)preview);
        }
        return preview;
    }

    private String getCodeUnitPreview(CodeUnitFormat format) {
        Symbol s;
        Address addr = this.location.getAddress();
        if (addr.isExternalAddress() && (s = this.program.getSymbolTable().getPrimarySymbol(addr)) != null) {
            ExternalLocation extLoc = this.program.getExternalManager().getExternalLocation(s);
            DataType dt = extLoc.getDataType();
            if (dt == null) {
                dt = DataType.DEFAULT;
            }
            return dt.getMnemonic(dt.getDefaultSettings());
        }
        CodeUnit cu = this.program.getListing().getCodeUnitAt(addr);
        return this.getFormatedCodeUnitPreview(cu);
    }

    private String getFormatedCodeUnitPreview(CodeUnit cu) {
        String path;
        if (cu == null) {
            return null;
        }
        if (!(cu instanceof Data)) {
            return this.formatter.getRepresentationString(cu);
        }
        Data data = (Data)cu;
        Object preview = this.formatter.getRepresentationString((CodeUnit)data);
        if (data.getParent() != null && !(path = this.getDataPath(data)).equals(preview)) {
            preview = (String)preview + path;
        }
        return preview;
    }

    private String getDataPath(Data data) {
        String path = data.getComponentPathName();
        int dotIndex = path.indexOf(".");
        if (dotIndex != -1) {
            path = path.substring(dotIndex + 1);
        }
        Data parent = data.getParent();
        DataType parentType = parent.getDataType();
        String separator = ".";
        if (parentType instanceof Array) {
            separator = "";
        }
        return " (" + parentType.getName() + separator + path + ")";
    }

    private String getPreview(boolean htmlFriendly) {
        String preview = this.getProgramLocationPreview();
        if (preview != null) {
            return preview;
        }
        CodeUnit codeUnit = this.getCodeUnitContaining(this.address);
        if (codeUnit != null) {
            return this.getPreview(codeUnit, htmlFriendly);
        }
        return this.getAddressPreview();
    }

    private String getAddressPreview() {
        Symbol s;
        if (this.address.isExternalAddress() && (s = this.program.getSymbolTable().getPrimarySymbol(this.address)) != null) {
            ExternalLocation loc = this.program.getExternalManager().getExternalLocation(s);
            DataType dt = loc.getDataType();
            if (dt == null) {
                dt = DataType.DEFAULT;
            }
            return dt.getMnemonic(dt.getDefaultSettings());
        }
        return null;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        this.displayString = this.getPreview(false);
        return this.displayString;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String getHTMLDisplayString() {
        if (this.htmlDisplayString == null) {
            this.htmlDisplayString = "<html><pre>" + this.getPreview(true) + "</pre></html>";
        }
        return this.htmlDisplayString;
    }

    public ProgramLocation getProgramLocation() {
        return this.location;
    }

    @Override
    public int compareTo(PreviewTableCellData data) {
        return this.getDisplayString().compareTo(data.getDisplayString());
    }

    private String getProgramLocationPreview() {
        if (this.location instanceof FunctionSignatureFieldLocation) {
            return ((FunctionSignatureFieldLocation)this.location).getSignature();
        }
        if (this.location instanceof FunctionRepeatableCommentFieldLocation) {
            return this.getFunctionCommentPreview((FunctionRepeatableCommentFieldLocation)this.location);
        }
        if (this.location instanceof VariableLocation) {
            return this.getVariablePreview((VariableLocation)this.location);
        }
        if (this.location instanceof LabelFieldLocation) {
            return ((LabelFieldLocation)this.location).getName();
        }
        if (this.location instanceof MnemonicFieldLocation || this.location instanceof OperandFieldLocation) {
            return this.getCodeUnitPreview(this.formatter);
        }
        if (this.location instanceof CommentFieldLocation) {
            return this.getCommentPreview((CommentFieldLocation)this.location);
        }
        return null;
    }

    private String getVariablePreview(VariableLocation loc) {
        if (loc instanceof VariableCommentFieldLocation) {
            return ((VariableCommentFieldLocation)loc).getComment();
        }
        Variable var = loc.getVariable();
        if (var == null) {
            return "";
        }
        String comments = var.getComment();
        StringBuilder sb = new StringBuilder();
        DataType dt = var.getDataType();
        String dtName = "Unknown";
        if (dt != null) {
            dtName = dt.getDisplayName();
        }
        sb.append(dtName);
        sb.append(" ");
        sb.append(var.getVariableStorage().toString());
        sb.append(" ");
        sb.append(var.getName());
        if (comments != null) {
            sb.append(" ");
            sb.append(comments);
        }
        return sb.toString();
    }

    private String getCommentPreview(CommentFieldLocation loc) {
        String[] comment = loc.getComment();
        int row = loc.getRow();
        if (row >= 0 && row < comment.length) {
            return comment[row];
        }
        return "";
    }

    private String getFunctionCommentPreview(FunctionRepeatableCommentFieldLocation loc) {
        String[] comment = loc.getComment();
        int row = loc.getRow();
        if (row >= 0 && row < comment.length) {
            return comment[row];
        }
        return "";
    }
}

