/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.table.field.ProgramBasedDynamicTableColumnExtensionPoint;

public class NamespaceTableColumn
extends ProgramBasedDynamicTableColumnExtensionPoint<ProgramLocation, String> {
    public String getColumnName() {
        return "Namespace";
    }

    public String getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        if (rowObject instanceof LabelFieldLocation) {
            LabelFieldLocation labelFieldLocation = (LabelFieldLocation)rowObject;
            String parentPath = labelFieldLocation.getSymbolPath().getParentPath();
            return parentPath == null ? "Global" : parentPath;
        }
        Symbol symbol = this.getSymbol(rowObject, program);
        if (symbol != null && !symbol.isDeleted() && !symbol.isDynamic()) {
            return symbol.getParentNamespace().getName(true);
        }
        Function function = program.getFunctionManager().getFunctionContaining(rowObject.getAddress());
        if (function != null) {
            return function.getSymbol().getName(true);
        }
        return null;
    }

    private Symbol getSymbol(ProgramLocation rowObject, Program program) throws IllegalArgumentException {
        Variable var;
        ProgramLocation location = rowObject;
        if (rowObject instanceof VariableLocation && (var = ((VariableLocation)rowObject).getVariable()) != null) {
            return var.getSymbol();
        }
        Address address = location.getAddress();
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(address);
        if (symbol != null) {
            return symbol;
        }
        return null;
    }
}

