/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.List;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheTable;
import org.eclipse.jgit.internal.storage.pack.PackExt;

class AggregatedBlockCacheStats
implements DfsBlockCacheTable.BlockCacheStats {
    private final List<DfsBlockCacheTable.BlockCacheStats> blockCacheStats;

    static DfsBlockCacheTable.BlockCacheStats fromStatsList(List<DfsBlockCacheTable.BlockCacheStats> blockCacheStats) {
        if (blockCacheStats.size() == 1) {
            return blockCacheStats.get(0);
        }
        return new AggregatedBlockCacheStats(blockCacheStats);
    }

    private AggregatedBlockCacheStats(List<DfsBlockCacheTable.BlockCacheStats> blockCacheStats) {
        this.blockCacheStats = blockCacheStats;
    }

    @Override
    public String getName() {
        return AggregatedBlockCacheStats.class.getName();
    }

    @Override
    public long[] getCurrentSize() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getCurrentSize());
        }
        return sums;
    }

    @Override
    public long[] getHitCount() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getHitCount());
        }
        return sums;
    }

    @Override
    public long[] getMissCount() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getMissCount());
        }
        return sums;
    }

    @Override
    public long[] getTotalRequestCount() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getTotalRequestCount());
        }
        return sums;
    }

    @Override
    public long[] getHitRatio() {
        long[] hit = this.getHitCount();
        long[] miss = this.getMissCount();
        long[] ratio = new long[Math.max(hit.length, miss.length)];
        int i = 0;
        while (i < ratio.length) {
            long total;
            ratio[i] = i >= hit.length ? 0L : (i >= miss.length ? 100L : ((total = hit[i] + miss[i]) == 0L ? 0L : hit[i] * 100L / total));
            ++i;
        }
        return ratio;
    }

    @Override
    public long[] getEvictions() {
        long[] sums = AggregatedBlockCacheStats.emptyPackStats();
        for (DfsBlockCacheTable.BlockCacheStats blockCacheStatsEntry : this.blockCacheStats) {
            sums = AggregatedBlockCacheStats.add(sums, blockCacheStatsEntry.getEvictions());
        }
        return sums;
    }

    private static long[] emptyPackStats() {
        return new long[PackExt.values().length];
    }

    private static long[] add(long[] first, long[] second) {
        long[] sums = new long[Integer.max(first.length, second.length)];
        int i = 0;
        while (i < Integer.min(first.length, second.length)) {
            sums[i] = first[i] + second[i];
            ++i;
        }
        int j = i;
        while (j < first.length) {
            sums[j] = first[i];
            ++j;
        }
        j = i;
        while (j < second.length) {
            sums[j] = second[i];
            ++j;
        }
        return sums;
    }
}

