/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.analyzers.QueryJarManifestAnalyzer;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.JarUtils;

public class ManifestQueryJarProcessor
implements JarProcessor<Optional<String>> {
    private final JarFileResolver jarFileResolver;
    private String attributeName;
    private String sectionName;

    public ManifestQueryJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Optional<String>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Optional<String>>> set = new TreeSet<JarProcessor.JarFileResult<Optional<String>>>();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarfile(jarFile));
        }
        return set;
    }

    private JarProcessor.JarFileResult<Optional<String>> processJarfile(JarFile jarFile) {
        Optional<Manifest> manifest = JarUtils.getManifest(jarFile);
        if (manifest.isPresent()) {
            QueryJarManifestAnalyzer analyzer = new QueryJarManifestAnalyzer(this.sectionName, this.attributeName);
            analyzer.handle(jarFile, manifest.get());
            return JarProcessor.JarFileResult.of(jarFile, analyzer.getResult());
        }
        return JarProcessor.JarFileResult.of(jarFile, Optional.empty());
    }
}

