/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import jflex.base.IntPair;
import jflex.chars.Interval;
import jflex.core.Action;
import jflex.core.LexScan;
import jflex.core.Macros;
import jflex.core.RegExp;
import jflex.core.RegExp1;
import jflex.core.RegExp2;
import jflex.core.RegExpException;
import jflex.core.RegExps;
import jflex.core.SemCheck;
import jflex.core.unicode.CharClasses;
import jflex.core.unicode.IntCharSet;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.state.StateSet;
import jflex.state.StateSetEnumerator;

public final class NFA {
    private StateSet[][] table;
    private StateSet[] epsilon;
    private boolean[] isFinal;
    private Action[] action;
    private int numStates;
    private final int numInput;
    private int numLexStates;
    private final int estSize;
    private CharClasses classes;
    private LexScan scanner;
    private RegExps regExps;
    private final StateSetEnumerator states = new StateSetEnumerator();
    private final StateSet tempStateSet = new StateSet();

    public NFA(int numInput, int estSize) {
        this.numInput = numInput;
        this.estSize = estSize;
        this.numStates = 0;
        this.epsilon = new StateSet[estSize];
        this.action = new Action[estSize];
        this.isFinal = new boolean[estSize];
        this.table = new StateSet[estSize][numInput];
    }

    public NFA(int numInput, LexScan scanner, RegExps regExps, Macros macros, CharClasses classes) {
        this(numInput, regExps.NFASize(macros) + 2 * scanner.states.number());
        this.scanner = scanner;
        this.regExps = regExps;
        this.classes = classes;
        this.numLexStates = scanner.states.number();
        int new_num = this.numEntryStates();
        this.ensureCapacity(new_num);
        this.numStates = new_num;
    }

    public StateSet epsilon(int i) {
        return this.epsilon[i];
    }

    public int numEntryStates() {
        return 2 * (this.numLexStates + this.regExps.gen_look_count);
    }

    public int numInput() {
        return this.numInput;
    }

    public int numLexStates() {
        return this.numLexStates;
    }

    public int numStates() {
        return this.numStates;
    }

    public StateSet reachableStates(int currentState, int nextChar) {
        return this.table[currentState][nextChar];
    }

    public StateSetEnumerator states() {
        return this.states;
    }

    public StateSet tempStateSet() {
        return this.tempStateSet;
    }

    public void addStandaloneRule() {
        int start = this.numStates;
        int end = this.numStates + 1;
        for (int c = 0; c < this.classes.getNumClasses(); ++c) {
            this.addTransition(start, c, end);
        }
        for (int i = 0; i < this.numLexStates * 2; ++i) {
            this.addEpsilonTransition(i, start);
        }
        this.action[end] = new Action("System.out.print(yytext());", Integer.MAX_VALUE);
        this.isFinal[end] = true;
    }

    public void addRegExp(int regExpNum) {
        IntPair nfa = this.insertNFA(this.regExps.getRegExp(regExpNum));
        List<Integer> lexStates = this.regExps.getStates(regExpNum);
        if (lexStates.isEmpty()) {
            lexStates = this.scanner.states.getInclusiveStates();
        }
        for (Integer stateNum : lexStates) {
            if (!this.regExps.isBOL(regExpNum)) {
                this.addEpsilonTransition(2 * stateNum, nfa.start());
            }
            this.addEpsilonTransition(2 * stateNum + 1, nfa.start());
        }
        if (this.regExps.getLookAhead(regExpNum) != null) {
            Action a = this.regExps.getAction(regExpNum);
            if (a != null && a.lookAhead() == Action.Kind.FINITE_CHOICE) {
                this.insertLookAheadChoices(nfa.end(), a, this.regExps.getLookAhead(regExpNum));
                this.scanner.actions.remove(a);
            } else {
                RegExp r1 = this.regExps.getRegExp(regExpNum);
                RegExp r2 = this.regExps.getLookAhead(regExpNum);
                IntPair look = this.insertNFA(r2);
                this.addEpsilonTransition(nfa.end(), look.start());
                this.action[look.end()] = a;
                this.isFinal[look.end()] = true;
                if (a != null && a.lookAhead() == Action.Kind.GENERAL_LOOK) {
                    IntPair forward = this.insertNFA(r1);
                    IntPair backward = this.insertNFA(r2.rev());
                    this.isFinal[forward.end()] = true;
                    this.action[forward.end()] = new Action(Action.Kind.FORWARD_ACTION);
                    this.isFinal[backward.end()] = true;
                    this.action[backward.end()] = new Action(Action.Kind.BACKWARD_ACTION);
                    int entry = 2 * (this.regExps.getLookEntry(regExpNum) + this.numLexStates);
                    this.addEpsilonTransition(entry, forward.start());
                    this.addEpsilonTransition(entry + 1, backward.start());
                    a.setEntryState(entry);
                }
            }
        } else {
            this.action[nfa.end()] = this.regExps.getAction(regExpNum);
            this.isFinal[nfa.end()] = true;
        }
    }

    private void insertLookAheadChoices(int baseEnd, Action a, RegExp lookAhead) {
        if (lookAhead.type == 41) {
            RegExp2 r = (RegExp2)lookAhead;
            this.insertLookAheadChoices(baseEnd, a, r.r1);
            this.insertLookAheadChoices(baseEnd, a, r.r2);
        } else {
            int len = SemCheck.length(lookAhead);
            if (len >= 0) {
                Action x;
                IntPair look = this.insertNFA(lookAhead);
                this.addEpsilonTransition(baseEnd, look.start());
                this.action[look.end()] = x = a.copyChoice(len);
                this.isFinal[look.end()] = true;
                this.scanner.actions.add(x);
            } else {
                throw new RegExpException(lookAhead);
            }
        }
    }

    private void ensureCapacity(int newNumStates) {
        int oldLength = this.epsilon.length;
        if (newNumStates < oldLength) {
            return;
        }
        int newStatesLength = Math.max(oldLength * 2, newNumStates);
        boolean[] newFinal = new boolean[newStatesLength];
        Action[] newAction = new Action[newStatesLength];
        StateSet[][] newTable = new StateSet[newStatesLength][this.numInput];
        StateSet[] newEpsilon = new StateSet[newStatesLength];
        System.arraycopy(this.isFinal, 0, newFinal, 0, this.numStates);
        System.arraycopy(this.action, 0, newAction, 0, this.numStates);
        System.arraycopy(this.epsilon, 0, newEpsilon, 0, this.numStates);
        System.arraycopy(this.table, 0, newTable, 0, this.numStates);
        this.isFinal = newFinal;
        this.action = newAction;
        this.epsilon = newEpsilon;
        this.table = newTable;
    }

    public void addTransition(int start, int input, int dest) {
        Out.debug("Adding transition (" + start + ", " + input + ", " + dest + ")");
        if (input == -1) {
            return;
        }
        int maxS = Math.max(start, dest) + 1;
        this.ensureCapacity(maxS);
        if (maxS > this.numStates) {
            this.numStates = maxS;
        }
        if (this.table[start][input] != null) {
            this.table[start][input].addState(dest);
        } else {
            this.table[start][input] = new StateSet(this.estSize, dest);
        }
    }

    public void addEpsilonTransition(int start, int dest) {
        int max = Math.max(start, dest) + 1;
        this.ensureCapacity(max);
        if (max > this.numStates) {
            this.numStates = max;
        }
        if (this.epsilon[start] != null) {
            this.epsilon[start].addState(dest);
        } else {
            this.epsilon[start] = new StateSet(this.estSize, dest);
        }
    }

    public boolean containsFinal(StateSet set) {
        this.states.reset(set);
        while (this.states.hasMoreElements()) {
            if (!this.isFinal[this.states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    public Action getAction(StateSet set) {
        this.states.reset(set);
        Action maxAction = null;
        Out.debug("Determining action of : " + set);
        while (this.states.hasMoreElements()) {
            Action currentAction = this.action[this.states.nextElement()];
            if (currentAction == null) continue;
            if (maxAction == null) {
                maxAction = currentAction;
                continue;
            }
            maxAction = maxAction.getHigherPriority(currentAction);
        }
        return maxAction;
    }

    private StateSet closure(int startState) {
        StateSet notvisited = this.tempStateSet;
        StateSet closure = new StateSet(this.numStates, startState);
        notvisited.clear();
        notvisited.addState(startState);
        while (notvisited.containsElements()) {
            int state = notvisited.getAndRemoveElement();
            notvisited.add(closure.complement(this.epsilon[state]));
            closure.add(this.epsilon[state]);
        }
        return closure;
    }

    public void epsilonFill() {
        for (int i = 0; i < this.numStates; ++i) {
            this.epsilon[i] = this.closure(i);
        }
    }

    private StateSet DFAEdge(StateSet start, int input) {
        this.tempStateSet.clear();
        this.states.reset(start);
        while (this.states.hasMoreElements()) {
            this.tempStateSet.add(this.table[this.states.nextElement()][input]);
        }
        StateSet result = new StateSet(this.tempStateSet);
        this.states.reset(this.tempStateSet);
        while (this.states.hasMoreElements()) {
            result.add(this.epsilon[this.states.nextElement()]);
        }
        return result;
    }

    public void dumpTable() {
        Out.dump(this.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.numStates; ++i) {
            result.append("State");
            if (this.isFinal[i]) {
                result.append("[FINAL");
                String l = this.action[i].lookString();
                if (!Objects.equals(l, "")) {
                    result.append(", ");
                    result.append(l);
                }
                result.append("]");
            }
            result.append(" ").append(i).append(Out.NL);
            for (int input = 0; input < this.numInput; ++input) {
                if (this.table[i][input] == null || !this.table[i][input].containsElements()) continue;
                result.append("  with ").append(input).append(" in ").append(this.table[i][input]).append(Out.NL);
            }
            if (this.epsilon[i] == null || !this.epsilon[i].containsElements()) continue;
            result.append("  with epsilon in ").append(this.epsilon[i]).append(Out.NL);
        }
        return result.toString();
    }

    public void writeDot(File file) {
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            writer.println(this.dotFormat());
            writer.close();
        }
        catch (IOException e) {
            Out.error(ErrorMessages.FILE_WRITE, file);
            throw new GeneratorException(e);
        }
    }

    public String dotFormat() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("digraph NFA {").append(Out.NL);
        result.append("rankdir = LR").append(Out.NL);
        for (i = 0; i < this.numStates; ++i) {
            if (!this.isFinal[i]) continue;
            result.append(i);
            result.append(" [shape = doublecircle]");
            result.append(Out.NL);
        }
        for (i = 0; i < this.numStates; ++i) {
            for (int input = 0; input < this.numInput; ++input) {
                if (this.table[i][input] == null) continue;
                for (int s : this.table[i][input]) {
                    result.append(i).append(" -> ").append(s);
                    result.append(" [label=\"").append(this.classes.toString(input)).append("\"]").append(Out.NL);
                }
            }
            if (this.epsilon[i] == null) continue;
            for (int s : this.epsilon[i]) {
                result.append(i).append(" -> ").append(s).append(" [style=dotted]").append(Out.NL);
            }
        }
        result.append("}").append(Out.NL);
        return result.toString();
    }

    private void insertLetterNFA(boolean caseless, int ch, int start, int end) {
        if (caseless) {
            IntCharSet set = IntCharSet.ofCharacter(ch);
            IntCharSet caselessSet = set.getCaseless(this.scanner.getUnicodeProperties());
            for (Interval interval : caselessSet.getIntervals()) {
                for (int elem = interval.start; elem <= interval.end; ++elem) {
                    this.addTransition(start, this.classes.getClassCode(elem), end);
                }
            }
        } else {
            this.addTransition(start, this.classes.getClassCode(ch), end);
        }
    }

    private IntPair insertStringNFA(boolean caseless, String str) {
        int start = this.numStates;
        int i = 0;
        int pos = 0;
        while (pos < str.length()) {
            int ch = str.codePointAt(pos);
            if (caseless) {
                IntCharSet set = IntCharSet.ofCharacter(ch);
                IntCharSet caselessSet = set.getCaseless(this.scanner.getUnicodeProperties());
                for (Interval interval : caselessSet.getIntervals()) {
                    for (int elem = interval.start; elem <= interval.end; ++elem) {
                        this.addTransition(i + start, this.classes.getClassCode(elem), i + start + 1);
                    }
                }
            } else {
                this.addTransition(i + start, this.classes.getClassCode(ch), i + start + 1);
            }
            pos += Character.charCount(ch);
            ++i;
        }
        return IntPair.create(start, i + start);
    }

    private void insertClassNFA(IntCharSet set, int start, int end) {
        for (int aCl : this.classes.getClassCodes(set, false)) {
            this.addTransition(start, aCl, end);
        }
    }

    private IntPair complement(IntPair nfa) {
        StateSet currentState;
        int currentDFAState;
        int dfaStart = nfa.end() + 1;
        this.epsilonFill();
        HashMap<StateSet, Integer> dfaStates = new HashMap<StateSet, Integer>(this.numStates);
        ArrayList<StateSet> dfaList = new ArrayList<StateSet>(this.numStates);
        int numDFAStates = 0;
        StateSet newState = this.epsilon[nfa.start()];
        dfaStates.put(newState, numDFAStates);
        dfaList.add(newState);
        for (currentDFAState = 0; currentDFAState <= numDFAStates; ++currentDFAState) {
            currentState = (StateSet)dfaList.get(currentDFAState);
            for (int input = 0; input < this.numInput; ++input) {
                newState = this.DFAEdge(currentState, input);
                if (!newState.containsElements()) continue;
                Integer nextDFAState = (Integer)dfaStates.get(newState);
                if (nextDFAState != null) {
                    this.addTransition(dfaStart + currentDFAState, input, dfaStart + nextDFAState);
                    continue;
                }
                if (Options.dump) {
                    Out.print("+");
                }
                dfaStates.put(newState, ++numDFAStates);
                dfaList.add(newState);
                this.addTransition(dfaStart + currentDFAState, input, dfaStart + numDFAStates);
            }
        }
        int start = dfaStart + numDFAStates + 1;
        int error = dfaStart + numDFAStates + 2;
        int end = dfaStart + numDFAStates + 3;
        this.addEpsilonTransition(start, dfaStart);
        for (int i = 0; i < this.numInput; ++i) {
            this.addTransition(error, i, error);
        }
        this.addEpsilonTransition(error, end);
        for (int s = 0; s <= numDFAStates; ++s) {
            currentState = (StateSet)dfaList.get(s);
            currentDFAState = dfaStart + s;
            if (!currentState.hasElement(nfa.end())) {
                this.addEpsilonTransition(currentDFAState, end);
            }
            for (int i = 0; i < this.numInput; ++i) {
                if (this.table[currentDFAState][i] != null) continue;
                this.addTransition(currentDFAState, i, error);
            }
        }
        this.removeDead(dfaStart, end);
        return IntPair.create(start, end);
    }

    private void removeDead(int start, int end) {
        StateSet notvisited = this.tempStateSet;
        StateSet reachable = new StateSet(this.numStates, start);
        notvisited.clear();
        notvisited.addState(start);
        while (notvisited.containsElements()) {
            int state = notvisited.getAndRemoveElement();
            notvisited.add(reachable.complement(this.epsilon[state]));
            reachable.add(this.epsilon[state]);
            for (int i = 0; i < this.numInput; ++i) {
                notvisited.add(reachable.complement(this.table[state][i]));
                reachable.add(this.table[state][i]);
            }
        }
        StateSet live = new StateSet(this.numStates, end);
        boolean changed = true;
        while (changed) {
            changed = false;
            Out.debug("live: " + live);
            StateSet complement = live.complement(reachable);
            if (complement == null) {
                throw new GeneratorException(new NullPointerException(), true);
            }
            for (int s : complement) {
                for (int i = 0; i < this.numInput; ++i) {
                    if (this.table[s][i] == null) continue;
                    for (int state : this.table[s][i]) {
                        if (!live.hasElement(state)) continue;
                        changed = true;
                        live.addState(s);
                    }
                }
                if (this.epsilon[s] == null) continue;
                for (int state : this.epsilon[s]) {
                    if (!live.hasElement(state)) continue;
                    changed = true;
                    live.addState(s);
                }
            }
        }
        if (!reachable.equals(live)) {
            for (int s : reachable) {
                for (int i = 0; i < this.numInput; ++i) {
                    if (this.table[s][i] == null) continue;
                    this.table[s][i].intersect(live);
                }
                if (this.epsilon[s] == null) continue;
                this.epsilon[s].intersect(live);
            }
        }
    }

    private void insertCCLNFA(RegExp regExp, int start, int end) {
        switch (regExp.type) {
            case 41: {
                RegExp2 r = (RegExp2)regExp;
                this.insertCCLNFA(r.r1, start, end);
                this.insertCCLNFA(r.r2, start, end);
                return;
            }
            case 55: {
                this.insertClassNFA((IntCharSet)((RegExp1)regExp).content, start, end);
                return;
            }
            case 47: {
                this.insertLetterNFA(false, (Integer)((RegExp1)regExp).content, start, end);
                return;
            }
            case 59: {
                this.insertLetterNFA(true, (Integer)((RegExp1)regExp).content, start, end);
                return;
            }
        }
        throw new RegExpException(regExp);
    }

    public IntPair insertNFA(RegExp regExp) {
        if (regExp.isCharClass()) {
            int start = this.numStates;
            int end = this.numStates + 1;
            this.ensureCapacity(end + 1);
            this.numStates = end + 1;
            this.insertCCLNFA(regExp, start, end);
            return IntPair.create(start, end);
        }
        switch (regExp.type) {
            case 41: {
                RegExp2 r = (RegExp2)regExp;
                IntPair nfa1 = this.insertNFA(r.r1);
                IntPair nfa2 = this.insertNFA(r.r2);
                int start = nfa2.end() + 1;
                int end = nfa2.end() + 2;
                this.addEpsilonTransition(start, nfa1.start());
                this.addEpsilonTransition(start, nfa2.start());
                this.addEpsilonTransition(nfa1.end(), end);
                this.addEpsilonTransition(nfa2.end(), end);
                return IntPair.create(start, end);
            }
            case 57: {
                RegExp2 r = (RegExp2)regExp;
                IntPair nfa1 = this.insertNFA(r.r1);
                IntPair nfa2 = this.insertNFA(r.r2);
                this.addEpsilonTransition(nfa1.end(), nfa2.start());
                return IntPair.create(nfa1.start(), nfa2.end());
            }
            case 39: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int start = nfa1.end() + 1;
                int end = nfa1.end() + 2;
                this.addEpsilonTransition(nfa1.end(), end);
                this.addEpsilonTransition(start, nfa1.start());
                this.addEpsilonTransition(start, end);
                this.addEpsilonTransition(nfa1.end(), nfa1.start());
                return IntPair.create(start, end);
            }
            case 40: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int start = nfa1.end() + 1;
                int end = nfa1.end() + 2;
                this.addEpsilonTransition(nfa1.end(), end);
                this.addEpsilonTransition(start, nfa1.start());
                this.addEpsilonTransition(nfa1.end(), nfa1.start());
                return IntPair.create(start, end);
            }
            case 42: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                this.addEpsilonTransition(nfa1.start(), nfa1.end());
                return IntPair.create(nfa1.start(), nfa1.end());
            }
            case 45: {
                return this.complement(this.insertNFA((RegExp)((RegExp1)regExp).content));
            }
            case 46: {
                return this.insertNFA(regExp.resolveTilde());
            }
            case 48: {
                return this.insertStringNFA(false, (String)((RegExp1)regExp).content);
            }
            case 58: {
                return this.insertStringNFA(true, (String)((RegExp1)regExp).content);
            }
        }
        throw new RegExpException(regExp);
    }
}

