/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.lexer.KtKeywordToken;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ/\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0000R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0018\u0010\u0013J-\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkParameterTypes", "function", "checkParameterType", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)V", "checkVarargParameters", "checkUninitializedParameter", "checkValOrVarParameter", "checkValOrVar", "checkValOrVar$checkers", "checkParameterNameChangedOnOverride", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFunctionParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunctionParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,173:1\n777#2:174\n873#2,2:175\n38#3:177\n60#3:178\n*S KotlinDebug\n*F\n+ 1 FirFunctionParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionParameterChecker\n*L\n69#1:174\n69#1:175,2\n159#1:177\n159#1:178\n*E\n"})
public final class FirFunctionParameterChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirFunctionParameterChecker INSTANCE = new FirFunctionParameterChecker();

    private FirFunctionParameterChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.checkVarargParameters(context2, reporter, declaration);
        this.checkParameterTypes(context2, reporter, declaration);
        this.checkUninitializedParameter(context2, reporter, declaration);
        this.checkValOrVarParameter(context2, reporter, declaration);
        this.checkParameterNameChangedOnOverride(context2, reporter, declaration);
    }

    private final void checkParameterTypes(CheckerContext context2, DiagnosticReporter reporter, FirFunction function2) {
        if (function2 instanceof FirAnonymousFunction) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            this.checkParameterType(reporter, context2, valueParameter2);
        }
        for (FirValueParameter valueParameter2 : function2.getContextParameters()) {
            this.checkParameterType(reporter, context2, valueParameter2);
        }
    }

    private final void checkParameterType(DiagnosticReporter reporter, CheckerContext context2, FirValueParameter valueParameter2) {
        FirTypeRef returnTypeRef = valueParameter2.getReturnTypeRef();
        if (!(returnTypeRef instanceof FirErrorTypeRef)) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirErrorTypeRef)returnTypeRef).getSource();
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtRealSourceElementKind.INSTANCE)) {
            return;
        }
        ConeDiagnostic diagnostic = ((FirErrorTypeRef)returnTypeRef).getDiagnostic();
        if (diagnostic instanceof ConeSimpleDiagnostic && ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.ValueParameterWithNoTypeAnnotation) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getVALUE_PARAMETER_WITHOUT_EXPLICIT_TYPE(), null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVarargParameters(CheckerContext context2, DiagnosticReporter reporter, FirFunction function2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isVararg()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            for (FirValueParameter parameter : varargParameters) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameter.getSource(), FirErrors.INSTANCE.getMULTIPLE_VARARG_PARAMETERS(), null, 8, null);
            }
        }
        for (FirValueParameter varargParameter : varargParameters) {
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(varargParameter.getReturnTypeRef());
            ConeKotlinType coneKotlinType = function2 instanceof FirAnonymousFunction ? coneType : FirTypeUtilsKt.arrayElementType$default(coneType, false, 1, null);
            if (coneKotlinType == null || (object = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, coneKotlinType)) == null) continue;
            Object varargParameterType = object;
            if (!ConeBuiltinTypeUtilsKt.isNothingOrNullableNothing(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirHelpersKt.leastUpperBound((ConeKotlinType)varargParameterType, context2.getSession()))) && (!FirHelpersKt.isValueClass((ConeKotlinType)varargParameterType, context2.getSession()) || ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType((ConeKotlinType)varargParameterType))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)varargParameter.getSource(), FirErrors.INSTANCE.getFORBIDDEN_VARARG_PARAMETER_TYPE(), varargParameterType, null, 16, null);
        }
    }

    private final void checkUninitializedParameter(CheckerContext context2, DiagnosticReporter reporter, FirFunction function2) {
        Iterator iterator2 = ((Iterable)function2.getValueParameters()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index = n2++;
            FirValueParameter parameter = (FirValueParameter)iterator2.next();
            FirExpression firExpression = parameter.getDefaultValue();
            if (firExpression == null) continue;
            firExpression.accept(new FirVisitorVoid(function2, index, context2, reporter){
                final /* synthetic */ FirFunction $function;
                final /* synthetic */ int $index;
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ DiagnosticReporter $reporter;
                {
                    this.$function = $function;
                    this.$index = $index;
                    this.$context = $context;
                    this.$reporter = $reporter;
                }

                public void visitElement(FirElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    element.acceptChildren(this);
                }

                public void visitQualifiedAccessExpression(FirQualifiedAccessExpression qualifiedAccessExpression) {
                    int referredParameterIndex;
                    FirValueParameterSymbol referredParameter;
                    block5: {
                        int n2;
                        Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
                        FirValueParameterSymbol firValueParameterSymbol = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default(qualifiedAccessExpression.getCalleeReference(), false, 1, null);
                        if (firValueParameterSymbol == null) {
                            return;
                        }
                        referredParameter = firValueParameterSymbol;
                        List<FirValueParameter> $this$indexOfFirst$iv = this.$function.getValueParameters();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<FirValueParameter> iterator2 = $this$indexOfFirst$iv.iterator();
                        while (iterator2.hasNext()) {
                            FirValueParameter item$iv;
                            FirValueParameter it = item$iv = iterator2.next();
                            boolean bl = false;
                            if (Intrinsics.areEqual(it.getSymbol(), referredParameter)) {
                                n2 = index$iv;
                                break block5;
                            }
                            ++index$iv;
                        }
                        n2 = referredParameterIndex = -1;
                    }
                    if (referredParameterIndex < 0) {
                        return;
                    }
                    if (this.$index <= referredParameterIndex) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)this.$context, this.$reporter, (AbstractKtSourceElement)qualifiedAccessExpression.getSource(), FirErrors.INSTANCE.getUNINITIALIZED_PARAMETER(), (Object)referredParameter, null, 16, null);
                    }
                }

                public void visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression) {
                    Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
                    this.visitQualifiedAccessExpression(propertyAccessExpression);
                }
            });
        }
    }

    private final void checkValOrVarParameter(CheckerContext context2, DiagnosticReporter reporter, FirFunction function2) {
        if (function2 instanceof FirConstructor && ((FirConstructor)function2).isPrimary()) {
            return;
        }
        for (FirValueParameter valueParameter2 : function2.getValueParameters()) {
            this.checkValOrVar$checkers(reporter, context2, valueParameter2);
        }
    }

    public final void checkValOrVar$checkers(@NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, @NotNull FirValueParameter valueParameter2) {
        block3: {
            KtSourceElement source;
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
            KtSourceElement ktSourceElement = source = valueParameter2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
            KtKeywordToken ktKeywordToken = FirKeywordUtilsKt.getValOrVarKeyword(source);
            if (ktKeywordToken == null) break block3;
            KtKeywordToken it = ktKeywordToken;
            boolean bl = false;
            if (valueParameter2.getContainingDeclarationSymbol() instanceof FirConstructorSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER(), (Object)it, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAL_OR_VAR_ON_FUN_PARAMETER(), (Object)it, null, 16, null);
            }
        }
    }

    private final void checkParameterNameChangedOnOverride(CheckerContext context2, DiagnosticReporter reporter, FirFunction function2) {
        block4: {
            block3: {
                if (!(function2 instanceof FirSimpleFunction)) break block3;
                FirMemberDeclaration $this$isOverride$iv = function2;
                boolean $i$f$isOverride = false;
                if (!$this$isOverride$iv.getStatus().isOverride()) break block3;
                FirMemberDeclaration $this$hasStableParameterNames$iv = function2;
                boolean $i$f$getHasStableParameterNames = false;
                if ($this$hasStableParameterNames$iv.getStatus().getHasStableParameterNames()) break block4;
            }
            return;
        }
        for (FirNamedFunctionSymbol overriddenFunctionSymbol : FirHelpersKt.directOverriddenFunctionsSafe(context2, ((FirSimpleFunction)function2).getSymbol())) {
            if (!overriddenFunctionSymbol.getResolvedStatus().getHasStableParameterNames()) continue;
            DeclarationUtilsKt.checkValueParameterNamesWith(((FirSimpleFunction)function2).getSymbol(), overriddenFunctionSymbol, (arg_0, arg_1, arg_2) -> FirFunctionParameterChecker.checkParameterNameChangedOnOverride$lambda$0(context2, reporter, arg_0, arg_1, arg_2));
        }
    }

    private static final Unit checkParameterNameChangedOnOverride$lambda$0(CheckerContext $context, DiagnosticReporter $reporter, FirValueParameterSymbol currentParameter, FirValueParameterSymbol overriddenParameter, int n2) {
        Intrinsics.checkNotNullParameter(currentParameter, "currentParameter");
        Intrinsics.checkNotNullParameter(overriddenParameter, "overriddenParameter");
        DiagnosticContext diagnosticContext2 = $context;
        AbstractKtSourceElement abstractKtSourceElement = currentParameter.getSource();
        KtDiagnosticFactory2<FirRegularClassSymbol, FirValueParameterSymbol> ktDiagnosticFactory2 = FirErrors.INSTANCE.getPARAMETER_NAME_CHANGED_ON_OVERRIDE();
        FirClassLikeSymbol<?> firClassLikeSymbol = ContainingClassUtilsKt.getContainingClassSymbol(overriddenParameter.getContainingDeclarationSymbol());
        Intrinsics.checkNotNull(firClassLikeSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol");
        KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, $reporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)((FirRegularClassSymbol)firClassLikeSymbol), (Object)overriddenParameter, null, 32, null);
        return Unit.INSTANCE;
    }
}

