/*********************************************************************
 * 
 *   Copyright (C) 2001-2004 Torsten Marek
 *
 * Filename:      tageditor.hpp
 * Description:   abstract base class for all tag editor classes
 * Author:        Torsten Marek <shlomme@gmx.net>
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ********************************************************************/

#ifndef TAGEDITOR_HPP
#define TAGEDITOR_HPP

#include <string>
#include <iostream>
#include "utf8converter.hpp"

using namespace std;
enum FieldID {
	Artist,
	Title,
	Album,
	Year,
	Track,
	Genre,
	Comment
};

// only unicode
class TagEditor
{
 public:
    // maybe add flag for readonly access
    TagEditor(const char*);
	virtual ~TagEditor();
    // return extension of the file
    virtual string extension() const = 0;
    // set value of field
    virtual int setField(FieldID, const string&) = 0;
    // get value of field
	virtual string getField(FieldID) const = 0;
    // remove field from tag
	virtual int removeField(FieldID) = 0;
    // returns true if fields exists
    virtual bool fieldExists(FieldID) const = 0;
    // write modified tag back to file
	virtual int writeTag() = 0;
    bool isOK() const
	{
		return (tag_insane == 0);
	}
    string filename() const
	{
		return fname;
	}
	bool altered() const
	{
		return (tag_altered != 0);
	}
    void setAltered(bool state)
    {
        tag_altered = state;
    }
    // returns the length of the track in seconds
    unsigned int length() const
	{
		return file_length;
	}
    unsigned int bitrate() const
    {
        return file_bitrate;
    }
    FieldID mapToID(const string& str) const;
protected:
    virtual UTF8Converter* converter() const;
    string fname;
	bool tag_altered;
	bool tag_insane;
    bool utf8_charset;
	unsigned int file_length;
    unsigned int file_bitrate;
};

#endif // TAGEDITOR_HPP
