/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.LookupException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Named
@Singleton
public class DefaultLookup
implements Lookup {
    private final PlexusContainer container;

    @Inject
    public DefaultLookup(PlexusContainer container) {
        this.container = container;
    }

    public <T> T lookup(Class<T> type) {
        try {
            return (T)this.container.lookup(type);
        }
        catch (ComponentLookupException e) {
            throw new LookupException((Exception)((Object)e));
        }
    }

    public <T> T lookup(Class<T> type, String name) {
        try {
            return (T)this.container.lookup(type, name);
        }
        catch (ComponentLookupException e) {
            throw new LookupException((Exception)((Object)e));
        }
    }

    public <T> Optional<T> lookupOptional(Class<T> type) {
        try {
            return Optional.of(this.container.lookup(type));
        }
        catch (ComponentLookupException e) {
            if (e.getCause() instanceof NoSuchElementException) {
                return Optional.empty();
            }
            throw new LookupException((Exception)((Object)e));
        }
    }

    public <T> Optional<T> lookupOptional(Class<T> type, String name) {
        try {
            return Optional.of(this.container.lookup(type, name));
        }
        catch (ComponentLookupException e) {
            if (e.getCause() instanceof NoSuchElementException) {
                return Optional.empty();
            }
            throw new LookupException((Exception)((Object)e));
        }
    }

    public <T> List<T> lookupList(Class<T> type) {
        try {
            return this.container.lookupList(type);
        }
        catch (ComponentLookupException e) {
            throw new LookupException((Exception)((Object)e));
        }
    }

    public <T> Map<String, T> lookupMap(Class<T> type) {
        try {
            return this.container.lookupMap(type);
        }
        catch (ComponentLookupException e) {
            throw new LookupException((Exception)((Object)e));
        }
    }
}

