'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const Event = require('./Event.cjs');

// https://html.spec.whatwg.org/multipage/webappapis.html#errorevent
class ErrorEvent extends Event.Event {
  constructor(type, eventInitDict) {
    super(type, eventInitDict);
    this.message = eventInitDict.message;
    this.filename = eventInitDict.filename;
    this.lineno = eventInitDict.lineno;
    this.colno = eventInitDict.colno;
    this.error = eventInitDict.error;
  }
}

exports.ErrorEvent = ErrorEvent;
