'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const Event = require('./Event.cjs');

// https://html.spec.whatwg.org/multipage/popover.html#toggleevent
class ToggleEvent extends Event.Event {
  constructor(type, eventInitDict) {
    super(type, eventInitDict);
    this.oldState = eventInitDict.oldState;
    this.newState = eventInitDict.newState;
  }
}

exports.ToggleEvent = ToggleEvent;
