import type { RemoteReceiverElement } from '@remote-dom/core/receivers';
import type { RemoteNodeRenderOptions } from '../types.ts';
export interface RemoteElementPropsOptions<Props = {}> {
    /**
     * Customizes the props your wrapper React component will have for event listeners
     * on the underlying custom element. The key is the prop name on the React component,
     * and the value is an options object containing the event name on the custom element.
     *
     * @example
     * ```tsx
     * const props = usePropsForRemoteElement(element, {
     *   eventProps: {
     *     onClick: {event: 'click'},
     *   },
     * });
     * ```
     */
    eventProps?: {
        [K in keyof Props]?: {
            /**
             * The event name that corresponds to this prop.
             */
            event: string;
        };
    };
}
/**
 * Converts a remote element into props for a React element. In addition to passing along
 * the `properties` of that element, this hook will convert any child elements with a `slot`
 * property into a prop of the same name, with the value rendered to a React element.
 */
export declare function usePropsForRemoteElement<Props extends Record<string, any> = {}>(element: RemoteReceiverElement, options: RemoteNodeRenderOptions & RemoteElementPropsOptions<Props>): Props;
export declare function usePropsForRemoteElement<Props extends Record<string, any> = {}>(element: RemoteReceiverElement | undefined, options: RemoteNodeRenderOptions & RemoteElementPropsOptions<Props>): Props | undefined;
//# sourceMappingURL=props-for-element.d.ts.map