import type { EventTarget, AbortBehavior, EventHandlerMap } from './types.ts';
/**
 * Listens to an `event` on the `target` object. Instead of providing a callback
 * function to run when the event is emitted, this function returns an `AsyncGenerator`
 * that yields each event as it is emitted.
 *
 * @param target The target to add the event handler to.
 * @param event The name of the event you are targeting.
 *
 * @returns An `AsyncGenerator` that yields each event as it is emitted.
 *
 * @example
 * const button = document.querySelector('button');
 *
 * for await (const event of on(button, 'click')) {
 *   console.log('clicked!', event);
 * }
 */
export declare function on<Events extends EventHandlerMap = Record<string, unknown>, Event extends keyof Events = keyof Events>(target: EventTarget<Events>, event: Event, options?: {
    /**
     * An `AbortSignal` to cancel listening to the event.
     */
    signal?: AbortSignal;
    /**
     * How to handle the `AbortSignal` being aborted. Defaults to `'resolve'`,
     * which causes the iterator to complete. If set to `'reject'`, the iterator
     * will throw an `AbortError` when the signal is aborted instead.
     */
    abort?: AbortBehavior;
}): AsyncGenerator<Events[Event], void, void>;
//# sourceMappingURL=on.d.ts.map