import { NEXT } from './constants.mjs';
import { Node } from './Node.mjs';

class ChildNode extends Node {
  remove() {
    const parent = this.parentNode;
    if (!parent) return;
    parent.removeChild(this);
  }
  replaceWith(...nodes) {
    const parent = this.parentNode;
    if (!parent) return;
    const node = toNode(parent, nodes[0]);
    const next = node[NEXT];
    parent.replaceChild(this, node);
    for (let i = 1; i < nodes.length; i++) {
      parent.insertBefore(toNode(parent, nodes[i]), next);
    }
  }
  before(...nodes) {
    const parent = this.parentNode;
    if (!parent) return;
    for (const node of nodes) {
      parent.insertBefore(toNode(parent, node), this);
    }
  }
  after(...nodes) {
    const parent = this.parentNode;
    if (!parent) return;
    const next = this[NEXT];
    for (const node of nodes) {
      parent.insertBefore(toNode(parent, node), next);
    }
  }
}
function toNode(parent, node) {
  if (node instanceof Node) return node;
  const ownerDocument = parent.ownerDocument;
  return ownerDocument.createTextNode(String(node));
}

export { ChildNode, toNode };
