import { CONTENT } from './constants.mjs';
import { Element } from './Element.mjs';
import { parseHtml, serializeChildren } from './serialization.mjs';

class HTMLTemplateElement extends Element {
  get content() {
    let content = this[CONTENT];
    if (!content) {
      content = this.ownerDocument.createDocumentFragment();
      this[CONTENT] = content;
    }
    return content;
  }
  set content(_) {}
  set innerHTML(html) {
    this.content.replaceChildren(parseHtml(String(html), this));
  }
  get innerHTML() {
    const content = this[CONTENT];
    return content ? serializeChildren(content) : '';
  }
}

export { HTMLTemplateElement };
