/**
 * An `Error` that indicates that an operation was aborted before
 * it finished.
 *
 * @see https://github.com/nodejs/node/blob/5c65565108c626884c5c722bb512c7c1e5c1c809/lib/internal/errors.js#L843-L855
 */
export declare class AbortError extends Error {
    static test(error: unknown): error is AbortError;
    readonly code = "ABORT_ERR";
    readonly name = "AbortError";
    constructor(message?: string);
}
//# sourceMappingURL=AbortError.d.ts.map