import type { RemoteConnection } from '../types.ts';
/**
 * A wrapper around a `RemoteConnection` that batches mutations. By default, this
 * all calls are flushed in a queued microtask, but this can be customized by passing
 * a custom `batch` option.
 */
export declare class BatchingRemoteConnection {
    #private;
    constructor(connection: RemoteConnection, { batch, }?: {
        batch?: (action: () => void) => void;
    });
    call(id: string, method: string, ...args: readonly unknown[]): void;
    mutate(records: any[]): void;
    flush(): void;
}
//# sourceMappingURL=connection.d.ts.map