import { LISTENERS, OWNER_DOCUMENT } from './constants.ts';
import { type Event } from './Event.ts';
import type { Document } from './Document.ts';
declare const ONCE_LISTENERS: unique symbol;
export declare class EventTarget {
    [LISTENERS]: Map<string, Set<EventListenerOrEventListenerObject>> | undefined;
    [ONCE_LISTENERS]: WeakMap<EventListenerOrEventListenerObject, EventListener> | undefined;
    /**
     * Property set by entities that extend this class that are part of the DOM tree.
     * @internal
     */
    [OWNER_DOCUMENT]: Document | undefined;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject | null, options?: boolean | AddEventListenerOptions): void;
    removeEventListener(type: string, listener: EventListenerOrEventListenerObject | null, options?: boolean | EventListenerOptions): void;
    dispatchEvent(event: Event): boolean;
}
export {};
//# sourceMappingURL=EventTarget.d.ts.map