/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["739"],{91286:function(e){e.exports="---\ntitle: Oracle\nredirect_from:\n  - /docs/latest/administration-guide/databases/oracle\n---\n\n# Oracle\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\n## Supported versions\n\nMetabase supports the oldest supported version through the latest stable version. See [Oracle's Release Schedule of Current Database Releases](https://support.oracle.com/knowledge/Oracle%20Database%20Products/742060_1.html).\n\n## Edit connection details\n\nYou can edit these settings at any time. Just remember to save your changes.\n\n### Connection string\n\nPaste a connection string here to pre-fill the remaining fields below.\n\n### Display name\n\nThe display name for the database in the Metabase interface.\n\n### Host\n\nYour database's IP address, or its domain name (e.g., esc.mydatabase.com).\n\n### Port\n\nThe database port. E.g., 1521.\n\n### Oracle system ID (SID)\n\nUsually something like ORCL or XE. Optional if using service name.\n\n### Oracle service name\n\nOptional TNS alias.\n\n### Username\n\nThe database username for the account that you want to use to connect to your database. You can set up multiple connections to the same database using different user accounts to connect to the same database, each with different sets of [privileges](../users-roles-privileges.md).\n\n### Password\n\nThe password for the username that you use to connect to the database.\n\n### Use a secure connection (SSL)\n\nYou can use both client and server authentication (known as mutual authentication).\n\n### Connecting to Oracle Cloud Autonomous Database\n\nIf you've configured your database to require mutual TLS (mTLS), you'll need a [wallet](https://docs.oracle.com/en/cloud/paas/autonomous-database/serverless/adbsb/connect-download-wallet.html#GUID-DED75E69-C303-409D-9128-5E10ADD47A35). To download your wallet:\n\n1. Go to your Oracle Autonomous Database.\n2. Go to the database's details.\n3. Click on **DB connection**.\n4. Download the wallet.\n5. Create a password for the keyfile.\n6. Copy the `keystore.jks` file to wherever you store your Metabase configuration data.\n7. Use `JAVA_OPTS` to let Metabase know about the keystore's location and password (for more info on keystores, see the next section).\n8. In Metabase, on the data connection page, enter your `host`, `port`, and `service_name`. You can find these values in the `tsnnames.ora` file.\n\n#### Client authentication with a keystore\n\nTo configure the server (the Oracle server) to authenticate the identity of the client (Metabase), you need to\nconfigure a keystore file that includes the client's private key.\n\nYou'll import the client's private key into the keystore (rather than a root CA into a truststore file). Add the following JVM options for Metabase:\n\n```\n-Djavax.net.ssl.keyStore=/path/to/keystore.jks\n-Djavax.net.ssl.keyStoreType=JKS \\\n-Djavax.net.ssl.keyStorePassword=<keyStorePassword>\n```\n\nYou can define these with the `JAVA_OPTS` environment variable, like so:\n\n```sh\nJAVA_OPTS: \"-Djavax.net.ssl.keyStore=/scripts/keystore.jks -Djavax.net.ssl.keyStoreType=JKS -Djavax.net.ssl.keyStorePassword=<keyStorePassword>\"\n```\n\nWith this done, the Oracle server will authenticate Metabase using the private key when Metabase tries to connect over SSL.\n\n#### Server authentication with a truststore\n\nTo configure the client (Metabase) to authenticate the identity of the server (the Oracle server), you may need to\nconfigure a truststore file that includes the server's root CA, so that the JVM running Metabase trusts its\ncertificate chain. Refer to the\n[Oracle documentation](https://docs.oracle.com/javase/8/docs/technotes/tools/unix/keytool.html) on using `keytool` to manage key and truststore files, importing certificates, etc.\n\nFor more information on setting up a truststore for AWS RDS Oracle instances, see the\n[instructions provided by Amazon](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.Options.SSL.html#Appendix.Oracle.Options.SSL.JDBC).\n\nIf you need to connect to other databases using SSL, instead of creating a new truststore, you'll probably want to add the RDS CA to your existing truststore file (likely called `cacerts`).\n\n## Supported Oracle database and Oracle driver versions\n\n- **Driver version**: the minimum Oracle driver version should be 19c, regardless of which Java version or Oracle database version you have.\n- **Database version**: the minimum database version should be version 19c, as Oracle [no longer supports database versions before 19](https://endoflife.date/oracle-database).\n\n## Downloading the Oracle JDBC Driver JAR\n\nYou can download a JDBC driver from [Oracle's JDBC driver downloads page](https://www.oracle.com/technetwork/database/application-development/jdbc/downloads/index.html).\n\nWe recommend using the `ojdbc8.jar` JAR.\n\n## Adding the Oracle JDBC Driver JAR to the Metabase plugins directory\n\nIn your Metabase directory (the directory where you keep and run your metabase.jar), create a directory called `plugins` (if it doesn't already exist.\n\nMove the JAR you just downloaded (`ojdbc8.jar`) into the plugins directory, and restart Metabase. Metabase will automatically make the Oracle driver available when it starts back up.\n\n### When running from a JAR\n\nBy default, the plugins directory is called `plugins`, and lives in the same directory as the Metabase JAR.\n\nFor example, if you're running Metabase from a directory called `/app/`, you should move the Oracle JDBC driver JAR to `/app/plugins/`:\n\n```txt\n# example directory structure for running Metabase with Oracle support\n/app/metabase.jar\n/app/plugins/ojdbc8.jar\n```\n\n### When running from Docker\n\nThe process for adding plugins when running via Docker is similar, but you'll need to mount the `plugins` directory. Refer to instructions [here](../../installation-and-operation/running-metabase-on-docker.md#adding-external-dependencies-or-plugins) for more details.\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\n- [Managing databases](../../databases/connecting.md)\n- [Metadata editing](../../data-modeling/metadata-editing.md)\n- [Models](../../data-modeling/models.md)\n- [Setting data access permissions](../../permissions/data.md)\n"}}]);