/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_ENABLEARMSTREAMING
#define GEN_PASS_DECL_OUTERPRODUCTFUSION
#define GEN_PASS_DECL_TESTTILEALLOCATION
#define GEN_PASS_DECL_VECTORLEGALIZATION
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// EnableArmStreaming
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ENABLEARMSTREAMING
struct EnableArmStreamingOptions {
  mlir::arm_sme::ArmStreamingMode streamingMode = mlir::arm_sme::ArmStreamingMode::Streaming;
  mlir::arm_sme::ArmZaMode zaMode = mlir::arm_sme::ArmZaMode::Disabled;
  bool ifRequiredByOps = false;
  bool ifScalableAndSupported = false;
};
#undef GEN_PASS_DECL_ENABLEARMSTREAMING
#endif // GEN_PASS_DECL_ENABLEARMSTREAMING
#ifdef GEN_PASS_DEF_ENABLEARMSTREAMING
namespace impl {

template <typename DerivedT>
class EnableArmStreamingBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = EnableArmStreamingBase;

  EnableArmStreamingBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  EnableArmStreamingBase(const EnableArmStreamingBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  EnableArmStreamingBase& operator=(const EnableArmStreamingBase &) = delete;
  EnableArmStreamingBase(EnableArmStreamingBase &&) = delete;
  EnableArmStreamingBase& operator=(EnableArmStreamingBase &&) = delete;
  ~EnableArmStreamingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("enable-arm-streaming");
  }
  ::llvm::StringRef getArgument() const override { return "enable-arm-streaming"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Enable Armv9 Streaming SVE mode)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("EnableArmStreaming");
  }
  ::llvm::StringRef getName() const override { return "EnableArmStreaming"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<func::FuncDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(EnableArmStreamingBase<DerivedT>)

  EnableArmStreamingBase(EnableArmStreamingOptions options) : EnableArmStreamingBase() {
    streamingMode = std::move(options.streamingMode);
    zaMode = std::move(options.zaMode);
    ifRequiredByOps = std::move(options.ifRequiredByOps);
    ifScalableAndSupported = std::move(options.ifScalableAndSupported);
  }
protected:
  ::mlir::Pass::Option<mlir::arm_sme::ArmStreamingMode> streamingMode{*this, "streaming-mode", ::llvm::cl::desc(R"PO(Select how streaming-mode is managed at the function-level.)PO"), ::llvm::cl::init(mlir::arm_sme::ArmStreamingMode::Streaming), ::llvm::cl::values(
                clEnumValN(mlir::arm_sme::ArmStreamingMode::Disabled,
                           "disabled", "Streaming mode is disabled."),
                clEnumValN(mlir::arm_sme::ArmStreamingMode::Streaming,
                           "streaming",
                           "Streaming mode is part of the function interface "
                           "(ABI), caller manages PSTATE.SM on entry/exit."),
                clEnumValN(mlir::arm_sme::ArmStreamingMode::StreamingLocally,
                           "streaming-locally",
                           "Streaming mode is internal to the function, callee "
                           "manages PSTATE.SM on entry/exit."),
                clEnumValN(mlir::arm_sme::ArmStreamingMode::StreamingCompatible,
                           "streaming-compatible",
                           "Function supports both streaming and non-streaming "
                           "modes.")
          )};
  ::mlir::Pass::Option<mlir::arm_sme::ArmZaMode> zaMode{*this, "za-mode", ::llvm::cl::desc(R"PO(Select how ZA-storage is managed at the function-level.)PO"), ::llvm::cl::init(mlir::arm_sme::ArmZaMode::Disabled), ::llvm::cl::values(
                 clEnumValN(mlir::arm_sme::ArmZaMode::Disabled,
                            "disabled", "ZA storage is disabled."),
                 clEnumValN(mlir::arm_sme::ArmZaMode::NewZA,
                            "new-za",
                            "The function has ZA state. The ZA state is "
                            "created on entry and destroyed on exit."),
                 clEnumValN(mlir::arm_sme::ArmZaMode::InZA,
                            "in-za",
                            "The function uses ZA state. The ZA state may "
                            "be used for input."),
                 clEnumValN(mlir::arm_sme::ArmZaMode::OutZA,
                            "out-za",
                            "The function uses ZA state. The ZA state may "
                            "be used for output."),
                 clEnumValN(mlir::arm_sme::ArmZaMode::InOutZA,
                            "inout-za",
                            "The function uses ZA state. The ZA state may "
                            "be used for input and/or output."),
                 clEnumValN(mlir::arm_sme::ArmZaMode::PreservesZA,
                            "preserves-za",
                            "The function shares ZA state. The ZA state may "
                            "not be used for input and/or output and the "
                            "function must return with ZA unchanged")
           )};
  ::mlir::Pass::Option<bool> ifRequiredByOps{*this, "if-required-by-ops", ::llvm::cl::desc(R"PO(Only apply the selected streaming/ZA modes if the function contains ops that implement the ArmSMETileOpInterface.)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> ifScalableAndSupported{*this, "if-scalable-and-supported", ::llvm::cl::desc(R"PO(Only apply the selected streaming/ZA modes if the function contains supported scalable vector operations.)PO"), ::llvm::cl::init(false)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_ENABLEARMSTREAMING
#endif // GEN_PASS_DEF_ENABLEARMSTREAMING

//===----------------------------------------------------------------------===//
// OuterProductFusion
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_OUTERPRODUCTFUSION
#undef GEN_PASS_DECL_OUTERPRODUCTFUSION
#endif // GEN_PASS_DECL_OUTERPRODUCTFUSION
#ifdef GEN_PASS_DEF_OUTERPRODUCTFUSION
namespace impl {

template <typename DerivedT>
class OuterProductFusionBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = OuterProductFusionBase;

  OuterProductFusionBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  OuterProductFusionBase(const OuterProductFusionBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  OuterProductFusionBase& operator=(const OuterProductFusionBase &) = delete;
  OuterProductFusionBase(OuterProductFusionBase &&) = delete;
  OuterProductFusionBase& operator=(OuterProductFusionBase &&) = delete;
  ~OuterProductFusionBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arm-sme-outer-product-fusion");
  }
  ::llvm::StringRef getArgument() const override { return "arm-sme-outer-product-fusion"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Fuse 'arm_sme.outerproduct' operations into 2-way or 4-way widening variants)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("OuterProductFusion");
  }
  ::llvm::StringRef getName() const override { return "OuterProductFusion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<func::FuncDialect>();
    registry.insert<arm_sme::ArmSMEDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(OuterProductFusionBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_OUTERPRODUCTFUSION
#endif // GEN_PASS_DEF_OUTERPRODUCTFUSION

//===----------------------------------------------------------------------===//
// TestTileAllocation
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_TESTTILEALLOCATION
struct TestTileAllocationOptions {
  bool dumpTileLiveRanges = false;
  bool preprocessOnly = false;
};
std::unique_ptr<::mlir::Pass> createTestTileAllocation();
std::unique_ptr<::mlir::Pass> createTestTileAllocation(TestTileAllocationOptions options);
#undef GEN_PASS_DECL_TESTTILEALLOCATION
#endif // GEN_PASS_DECL_TESTTILEALLOCATION
#ifdef GEN_PASS_DEF_TESTTILEALLOCATION

namespace impl {
  std::unique_ptr<::mlir::Pass> createTestTileAllocation();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createTestTileAllocation(TestTileAllocationOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class TestTileAllocationBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = TestTileAllocationBase;

  TestTileAllocationBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  TestTileAllocationBase(const TestTileAllocationBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  TestTileAllocationBase& operator=(const TestTileAllocationBase &) = delete;
  TestTileAllocationBase(TestTileAllocationBase &&) = delete;
  TestTileAllocationBase& operator=(TestTileAllocationBase &&) = delete;
  ~TestTileAllocationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("test-arm-sme-tile-allocation");
  }
  ::llvm::StringRef getArgument() const override { return "test-arm-sme-tile-allocation"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Tests SME 'virtual tile' allocation)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TestTileAllocation");
  }
  ::llvm::StringRef getName() const override { return "TestTileAllocation"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<func::FuncDialect>();
    registry.insert<arm_sme::ArmSMEDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(TestTileAllocationBase<DerivedT>)

  TestTileAllocationBase(TestTileAllocationOptions options) : TestTileAllocationBase() {
    dumpTileLiveRanges = std::move(options.dumpTileLiveRanges);
    preprocessOnly = std::move(options.preprocessOnly);
  }
protected:
  ::mlir::Pass::Option<bool> dumpTileLiveRanges{*this, "dump-tile-live-ranges", ::llvm::cl::desc(R"PO(Dump the live ranges of SME tiles (for debugging))PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> preprocessOnly{*this, "preprocess-only", ::llvm::cl::desc(R"PO(Only preprocess IR so it is ready for tile allocation (but do not allocate any tiles))PO"), ::llvm::cl::init(false)};
private:

  friend std::unique_ptr<::mlir::Pass> createTestTileAllocation() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createTestTileAllocation(TestTileAllocationOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createTestTileAllocation() {
  return impl::createTestTileAllocation();
}

std::unique_ptr<::mlir::Pass> createTestTileAllocation(TestTileAllocationOptions options) {
  return impl::createTestTileAllocation(std::move(options));
}
#undef GEN_PASS_DEF_TESTTILEALLOCATION
#endif // GEN_PASS_DEF_TESTTILEALLOCATION

//===----------------------------------------------------------------------===//
// VectorLegalization
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_VECTORLEGALIZATION
#undef GEN_PASS_DECL_VECTORLEGALIZATION
#endif // GEN_PASS_DECL_VECTORLEGALIZATION
#ifdef GEN_PASS_DEF_VECTORLEGALIZATION
namespace impl {

template <typename DerivedT>
class VectorLegalizationBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = VectorLegalizationBase;

  VectorLegalizationBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  VectorLegalizationBase(const VectorLegalizationBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  VectorLegalizationBase& operator=(const VectorLegalizationBase &) = delete;
  VectorLegalizationBase(VectorLegalizationBase &&) = delete;
  VectorLegalizationBase& operator=(VectorLegalizationBase &&) = delete;
  ~VectorLegalizationBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arm-sme-vector-legalization");
  }
  ::llvm::StringRef getArgument() const override { return "arm-sme-vector-legalization"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalize vectors for ArmSME)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("VectorLegalization");
  }
  ::llvm::StringRef getName() const override { return "VectorLegalization"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<func::FuncDialect>();
    registry.insert<arm_sme::ArmSMEDialect>();
    registry.insert<vector::VectorDialect>();
    registry.insert<arith::ArithDialect>();
    registry.insert<index::IndexDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(VectorLegalizationBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_VECTORLEGALIZATION
#endif // GEN_PASS_DEF_VECTORLEGALIZATION
#ifdef GEN_PASS_REGISTRATION
// Generate registrations for all passes.
#define GEN_PASS_REGISTRATION_ENABLEARMSTREAMING
#define GEN_PASS_REGISTRATION_OUTERPRODUCTFUSION
#define GEN_PASS_REGISTRATION_TESTTILEALLOCATION
#define GEN_PASS_REGISTRATION_VECTORLEGALIZATION
#endif // GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// EnableArmStreaming Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ENABLEARMSTREAMING

inline void registerEnableArmStreaming() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::arm_sme::createEnableArmStreamingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerEnableArmStreamingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::arm_sme::createEnableArmStreamingPass();
  });
}

#undef GEN_PASS_REGISTRATION_ENABLEARMSTREAMING
#endif // GEN_PASS_REGISTRATION_ENABLEARMSTREAMING

//===----------------------------------------------------------------------===//
// OuterProductFusion Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_OUTERPRODUCTFUSION

inline void registerOuterProductFusion() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::arm_sme::createOuterProductFusionPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerOuterProductFusionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::arm_sme::createOuterProductFusionPass();
  });
}

#undef GEN_PASS_REGISTRATION_OUTERPRODUCTFUSION
#endif // GEN_PASS_REGISTRATION_OUTERPRODUCTFUSION

//===----------------------------------------------------------------------===//
// TestTileAllocation Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_TESTTILEALLOCATION

inline void registerTestTileAllocation() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestTileAllocation();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerTestTileAllocationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createTestTileAllocation();
  });
}

#undef GEN_PASS_REGISTRATION_TESTTILEALLOCATION
#endif // GEN_PASS_REGISTRATION_TESTTILEALLOCATION

//===----------------------------------------------------------------------===//
// VectorLegalization Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_VECTORLEGALIZATION

inline void registerVectorLegalization() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::arm_sme::createVectorLegalizationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerVectorLegalizationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::arm_sme::createVectorLegalizationPass();
  });
}

#undef GEN_PASS_REGISTRATION_VECTORLEGALIZATION
#endif // GEN_PASS_REGISTRATION_VECTORLEGALIZATION
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ArmSME Registration
//===----------------------------------------------------------------------===//

inline void registerArmSMEPasses() {
  registerEnableArmStreaming();
  registerOuterProductFusion();
  registerTestTileAllocation();
  registerVectorLegalization();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
#ifdef GEN_PASS_CLASSES
#error "GEN_PASS_CLASSES is deprecated; use per-pass macros"
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
