/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: TuneExtensionOps.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace  mlir::transform::tune  {

/// Represents a choice among its regions, i.e. sub-schedules
/// This op represents a choice over which of its regions is to be used.
/// 
///     When `selected_region` is provided, the semantics are that this op is to be
///     substituted for by the selected region, meaning the region's results become
///     the results of this op. Without a provided `selected_region`, the semantics
///     are that this non-deterministic choice is yet to be resolved -- which in
///     terms of the op's interpreted semantics is a failure.
/// 
///     The `selected_region` argument is either an `IntegerAttr` or a param holding
///     an `IntegerAttr`, which should provide a valid zero-based index with respect
///     to the number of alternatives, i.e. regions.
class AlternativesOp;

} // namespace  mlir::transform::tune 
namespace  mlir::transform::tune  {

/// Represents a tunable parameter with a set of options
/// Provides a representation for "tunables" within schedules.
/// 
///     Each op represents a single tunable, which has a `name` and a set
///     of valid `options` described by an attribute. Without a specified
///     `selected` option, this op represents a non-deterministic choice
///     that has yet to be resolved -- as such, the interpreter runtime
///     semantics is to raise a failure.
/// 
///     The non-deterministic choice is resolved through providing a
///     `selected` attribute. When provided, the interpreter runtime
///     semantics are to return the `selected` attribute as a param through
///     the op's result.
/// 
///     -----
/// 
///     In case the `options` attribute is an `ArrayAttr`, the verifier
///     checks that the provided `selected` attribute occurs in `options`.
class KnobOp;

} // namespace  mlir::transform::tune 
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace  mlir::transform::tune  {


//===----------------------------------------------------------------------===//
//  mlir::transform::tune ::AlternativesOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AlternativesOpGenericAdaptorBase {
public:
  struct Properties {
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using selected_region_attrTy = ::mlir::IntegerAttr;
    selected_region_attrTy selected_region_attr;

    auto getSelectedRegionAttr() const {
      auto &propStorage = this->selected_region_attr;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setSelectedRegionAttr(const ::mlir::IntegerAttr &propValue) {
      this->selected_region_attr = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.name == this->name &&
        rhs.selected_region_attr == this->selected_region_attr &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AlternativesOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.tune.alternatives", odsAttrs.getContext());
  }

  AlternativesOpGenericAdaptorBase(AlternativesOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::mlir::StringAttr getName();
  ::mlir::IntegerAttr getSelectedRegionAttrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().selected_region_attr);
    return attr;
  }

  ::std::optional< ::mlir::APInt > getSelectedRegionAttr();
  ::mlir::RegionRange getAlternatives() {
    return odsRegions.drop_front(0);
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class AlternativesOpGenericAdaptor : public detail::AlternativesOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AlternativesOpGenericAdaptorBase;
  static constexpr int odsIndex_selected_region_param = 0;
public:
  AlternativesOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AlternativesOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AlternativesOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AlternativesOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AlternativesOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AlternativesOpGenericAdaptor(RangeT values, const AlternativesOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AlternativesOp, typename = std::enable_if_t<std::is_same_v<LateInst, AlternativesOp>>>
  AlternativesOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSelectedRegionParam() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AlternativesOpAdaptor : public AlternativesOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AlternativesOpGenericAdaptor::AlternativesOpGenericAdaptor;
  AlternativesOpAdaptor(AlternativesOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AlternativesOp : public ::mlir::Op<AlternativesOp, ::mlir::OpTrait::VariadicRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<::mlir::transform::YieldOp>::Impl, ::mlir::OpTrait::NoRegionArguments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::RegionBranchOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AlternativesOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AlternativesOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_selected_region_param = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::RegionBranchOpInterface::Trait<AlternativesOp>::getEntrySuccessorRegions;
  using ::mlir::RegionBranchOpInterface::Trait<AlternativesOp>::getSuccessorRegions;
  using ::mlir::RegionBranchOpInterface::Trait<AlternativesOp>::getPredecessors;
  using ::mlir::RegionBranchOpInterface::Trait<AlternativesOp>::getPredecessorValues;
  using ::mlir::RegionBranchOpInterface::Trait<AlternativesOp>::areTypesCompatible;
  using ::mlir::transform::TransformOpInterface::Trait<AlternativesOp>::allowsRepeatedHandleOperands;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("name"), ::llvm::StringRef("selected_region_attr")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSelectedRegionAttrAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSelectedRegionAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.tune.alternatives");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformParamTypeInterface> getSelectedRegionParam() {
    auto operands = getODSOperands(0);
    return operands.empty() ? ::mlir::TypedValue<::mlir::transform::TransformParamTypeInterface>{} : ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformParamTypeInterface>>(*operands.begin());
  }

  ::mlir::MutableOperandRange getSelectedRegionParamMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getResults() {
    return getODSResults(0);
  }

  ::mlir::MutableArrayRef<::mlir::Region> getAlternatives() {
    return (*this)->getRegions().drop_front(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().name);
  }

  ::mlir::StringAttr getName();
  ::mlir::IntegerAttr getSelectedRegionAttrAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().selected_region_attr);
  }

  ::std::optional< ::mlir::APInt > getSelectedRegionAttr();
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setSelectedRegionAttrAttr(::mlir::IntegerAttr attr) {
    getProperties().selected_region_attr = attr;
  }

  ::mlir::Attribute removeSelectedRegionAttrAttr() {
      auto attr = getProperties().selected_region_attr;
      getProperties().selected_region_attr = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange results, ::mlir::StringAttr name, /*optional*/::mlir::IntegerAttr selected_region_attr, /*optional*/::mlir::Value selected_region_param, unsigned alternativesCount);
  static AlternativesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange results, ::mlir::StringAttr name, /*optional*/::mlir::IntegerAttr selected_region_attr, /*optional*/::mlir::Value selected_region_param, unsigned alternativesCount);
  static AlternativesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange results, ::mlir::StringAttr name, /*optional*/::mlir::IntegerAttr selected_region_attr, /*optional*/::mlir::Value selected_region_param, unsigned alternativesCount);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static AlternativesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static AlternativesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  static AlternativesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  static AlternativesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::OperandRange getEntrySuccessorOperands(::mlir::RegionSuccessor successor);
  void getSuccessorRegions(::mlir::RegionBranchPoint point, ::llvm::SmallVectorImpl<::mlir::RegionSuccessor> &regions);
  void getRegionInvocationBounds(::llvm::ArrayRef<::mlir::Attribute> operands, ::llvm::SmallVectorImpl<::mlir::InvocationBounds> &invocationBounds);
  ::mlir::DiagnosedSilenceableFailure apply(::mlir::transform::TransformRewriter &rewriter, ::mlir::transform::TransformResults &transformResults, ::mlir::transform::TransformState &state);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace  mlir::transform::tune 
MLIR_DECLARE_EXPLICIT_TYPE_ID( mlir::transform::tune ::AlternativesOp)

namespace  mlir::transform::tune  {


//===----------------------------------------------------------------------===//
//  mlir::transform::tune ::KnobOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class KnobOpGenericAdaptorBase {
public:
  struct Properties {
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    using optionsTy = ::mlir::Attribute;
    optionsTy options;

    auto getOptions() const {
      auto &propStorage = this->options;
      return ::llvm::cast<::mlir::Attribute>(propStorage);
    }
    void setOptions(const ::mlir::Attribute &propValue) {
      this->options = propValue;
    }
    using selectedTy = ::mlir::Attribute;
    selectedTy selected;

    auto getSelected() const {
      auto &propStorage = this->selected;
      return ::llvm::dyn_cast_or_null<::mlir::Attribute>(propStorage);
    }
    void setSelected(const ::mlir::Attribute &propValue) {
      this->selected = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.name == this->name &&
        rhs.options == this->options &&
        rhs.selected == this->selected &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  KnobOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.tune.knob", odsAttrs.getContext());
  }

  KnobOpGenericAdaptorBase(KnobOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::mlir::StringAttr getName();
  ::mlir::Attribute getOptionsAttr() {
    auto attr = ::llvm::cast<::mlir::Attribute>(getProperties().options);
    return attr;
  }

  ::mlir::Attribute getOptions();
  ::mlir::Attribute getSelectedAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().selected);
    return attr;
  }

  ::std::optional<::mlir::Attribute> getSelected();
};

} // namespace detail
template <typename RangeT>
class KnobOpGenericAdaptor : public detail::KnobOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::KnobOpGenericAdaptorBase;
public:
  KnobOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  KnobOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : KnobOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  KnobOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : KnobOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  KnobOpGenericAdaptor(RangeT values, const KnobOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = KnobOp, typename = std::enable_if_t<std::is_same_v<LateInst, KnobOp>>>
  KnobOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class KnobOpAdaptor : public KnobOpGenericAdaptor<::mlir::ValueRange> {
public:
  using KnobOpGenericAdaptor::KnobOpGenericAdaptor;
  KnobOpAdaptor(KnobOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class KnobOp : public ::mlir::Op<KnobOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::transform::TransformParamTypeInterface>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = KnobOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = KnobOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::transform::TransformOpInterface::Trait<KnobOp>::allowsRepeatedHandleOperands;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("name"), ::llvm::StringRef("options"), ::llvm::StringRef("selected")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOptionsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOptionsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getSelectedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getSelectedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.tune.knob");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformParamTypeInterface> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformParamTypeInterface>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().name);
  }

  ::mlir::StringAttr getName();
  ::mlir::Attribute getOptionsAttr() {
    return ::llvm::cast<::mlir::Attribute>(getProperties().options);
  }

  ::mlir::Attribute getOptions();
  ::mlir::Attribute getSelectedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().selected);
  }

  ::std::optional<::mlir::Attribute> getSelected();
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setOptionsAttr(::mlir::Attribute attr) {
    getProperties().options = attr;
  }

  void setSelectedAttr(::mlir::Attribute attr) {
    getProperties().selected = attr;
  }

  ::mlir::Attribute removeSelectedAttr() {
      auto attr = getProperties().selected;
      getProperties().selected = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KnobOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static KnobOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::DiagnosedSilenceableFailure apply(::mlir::transform::TransformRewriter &rewriter, ::mlir::transform::TransformResults &transformResults, ::mlir::transform::TransformState &state);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace  mlir::transform::tune 
MLIR_DECLARE_EXPLICIT_TYPE_ID( mlir::transform::tune ::KnobOp)


#endif // GET_OP_CLASSES

