import type { ProjectConfig } from './project-config.js';
/**
 * Check if an error is an ExitPromptError (user cancelled with Ctrl+C).
 * Used instead of instanceof check since @inquirer modules use dynamic imports.
 */
export declare function isExitPromptError(error: unknown): boolean;
/**
 * Result of interactive config creation prompts.
 */
export interface ConfigPromptResult {
    /** Whether to create config file */
    createConfig: boolean;
    /** Selected schema name */
    schema?: string;
    /** Project context (optional) */
    context?: string;
    /** Per-artifact rules (optional) */
    rules?: Record<string, string[]>;
}
/**
 * Prompt user to create project config interactively.
 * Used by experimental setup command.
 *
 * @param projectRoot - Optional project root for project-local schema resolution
 * @returns Config prompt result
 * @throws ExitPromptError if user cancels (Ctrl+C)
 */
export declare function promptForConfig(projectRoot?: string): Promise<ConfigPromptResult>;
/**
 * Serialize config to YAML string with proper multi-line formatting.
 *
 * @param config - Partial config object (schema required, context/rules optional)
 * @returns YAML string ready to write to file
 */
export declare function serializeConfig(config: Partial<ProjectConfig>): string;
//# sourceMappingURL=config-prompts.d.ts.map